#include <malloc.h>
#include <rand.h>
#include "libpgp5.h"

/*------------------------------------*/
void cnvenc5(FILE * inf, FILE * outf, void *cfbdat)
{
  unsigned char dbuf[10000], *bp;
  int j, k;

  fputc(0xc9, outf);            /* conventional encryption packet */
  bp = &dbuf[1];                /* special PGP iv header */
  dbuf[0] = 0xed;
  RAND_bytes(bp, 8);
  bp[8] = bp[6], bp[9] = bp[7];
  docfb(bp, 10, cfbdat);
  cfbreset(&bp[2], cfbdat);     /* PGP special restart */
  bp += 10;
  j = 10;
  for (;;) {                    /* packetize and encrypt */
    k = fread(bp, 1, 8192 - j, inf);
    if (k <= 0)
      break;
    docfb(bp, k, cfbdat);
    j += k;
    if (j == 8192) {
      fwrite(dbuf, 1, j + 1, outf);
      bp = &dbuf[1];
      j = 0;
    } else {
      if (j > 192) {
        fputc(0xc0 | ((j - 192) >> 8), outf);
        dbuf[0] = j - 192;
      } else
        dbuf[0] = j;
      fwrite(dbuf, 1, j + 1, outf);
    }
  }
  free(cfbdat);
}
