#ifndef GABA_DEFINE
struct tcpip_channel
{
  struct ssh_channel super;
  struct io_fd *socket;
};
extern struct lsh_class tcpip_channel_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcpip_channel_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_channel *i = (struct tcpip_channel *) o;
  mark((struct lsh_object *) i->socket);
}

struct lsh_class tcpip_channel_class =
{ STATIC_HEADER,
  &ssh_channel_class, "tcpip_channel", sizeof(struct tcpip_channel),
  do_tcpip_channel_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct tcpip_connected
{
  struct fd_callback super;
  struct tcpip_channel *channel;
  struct io_backend *backend;
  UINT32 block_size;
  struct channel_open_callback *response;
};
extern struct lsh_class tcpip_connected_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcpip_connected_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_connected *i = (struct tcpip_connected *) o;
  mark((struct lsh_object *) i->channel);
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->response);
}

struct lsh_class tcpip_connected_class =
{ STATIC_HEADER,
  &fd_callback_class, "tcpip_connected", sizeof(struct tcpip_connected),
  do_tcpip_connected_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct open_direct_tcpip
{
  struct channel_open super;
  struct io_backend *backend;
};
extern struct lsh_class open_direct_tcpip_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_open_direct_tcpip_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct open_direct_tcpip *i = (struct open_direct_tcpip *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class open_direct_tcpip_class =
{ STATIC_HEADER,
  &channel_open_class, "open_direct_tcpip", sizeof(struct open_direct_tcpip),
  do_open_direct_tcpip_mark,
  NULL
};
#endif /* !GABA_DECLARE */

static struct lsh_object *
make_tcpforward(void)
{
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
  return
    C2(Bp3(S, B1(COMMAND_UNIMPLEMENTED), COMMAND_UNIMPLEMENTED), COMMAND_UNIMPLEMENTED);
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
}
static struct lsh_object *
make_forward_connect(struct command *connect, struct command *start_io)
{
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
  return
    B2(((struct lsh_object *) start_io), ((struct lsh_object *) connect));
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
}
