/*

    ``gpgp'' Gnome/GTK Front for PGP
    Copyright (C) 1998  Max Valianskiy

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Revision: 1.2 $ 

*/

#ifndef PGMAN_H_INCLUDED
#define PGMAN_H_INCLUDED

#include <glib.h>

extern char* pgman_error;

GList* get_keylist(char* ring, int is_secret);
void pgp_add_key(char* file, char* ring);
void pgp_del_key(char* ring, char* uid);
void pgp_export_key(char* ring, char* uid, char* file);

struct key_options
{
 char* type;
 char* bits;
 char* fingerprint;
 char* keyid;
 char* date;

 GList* signatures;
};

void get_key_options(char* ring, char* uid, struct key_options* options);

typedef void (* PgmanActionFunc) (gpointer data);

void pgp_sign_action(char* options, char* data, int datalen, char** new, int* newlen, PgmanActionFunc func, gpointer data2);
void pgp_unsign_action(char* data, int datalen, char** new, int* newlen, PgmanActionFunc func, gpointer data2);

#endif
