/*
 * Copyright (C) 1997 Pretty Good Privacy, Inc.  All rights reserved.
 *
 */
//:PGPerror.c - convert error codes to strings and display in messagebox
//
//	$Id: PGPerror.c,v 1.4.2.2 1997/06/09 15:54:50 dgal Exp $
//

#include "pgpcomdlgx.h"
#include "..\include\spgp.h"

// external globals
extern HINSTANCE g_hInst;
extern CHAR g_szbuf[G_BUFLEN];

// local globals


//----------------------------------------------------|
//	get descriptive string for error code

BOOL PGPExport PGPcomdlgErrorToString (INT iCode, LPSTR szString,
											       UINT uLen) {

	UINT uIDS = 0;

	// pgplib error codes
	if (iCode == PGPERR_OK) return FALSE;
	if (iCode < 0) {
		switch (iCode) {
		case PGPERR_INTERRUPTED :
			return FALSE;

		case PGPERR_FILEIO_BADPKT :
			uIDS = IDS_ERR_CORRUPTPACKET;
			break;

		case PGPERR_KEYIO_WRITING :
			uIDS = IDS_ERR_KEYIOWRITING;
			break;

		case PGPERR_NO_FILE :
			uIDS = IDS_ERR_NOFILE;
			break;

		case PGPERR_NOMEM :
			uIDS = IDS_ERR_OUTOFMEMORY;
			break;

		case PGPERR_KEYDB_BADPASSPHRASE :
			uIDS = IDS_ERR_WRONGKEYPASSPHRASE;
			break;

		case PGPERR_KEYDB_DUPLICATE_USERID :
			uIDS = IDS_ERR_DUPLICATEUSERID;
			break;

		case PGPERR_KEYDB_DUPLICATE_CERT :
			uIDS = IDS_ERR_DUPLICATECERT;
			break;

		case PGPERR_FILE_PERMISSIONS :
			uIDS = IDS_ERR_FILEPERMISSIONS;
			break;

		default :
			strncpy (szString, pgperrString (iCode), uLen);
			szString[uLen-1] = '\0';
			return TRUE;
		}
		LoadString (g_hInst, uIDS, szString, uLen);
		szString[uLen-1] = '\0';
		return TRUE;
	}

	// other error codes
	switch (iCode) {
		// user cancel codes
		case PGPCOMDLG_CANCEL :
		case PGPCOMDLG_ALREADYOPEN :
 		case SIMPLEPGPKEYSEL_CANCEL:
		case KERNEL_CANCEL_ON_BUSY:
		case KEYSEL_CANCEL_ON_BUSY:
		case SIMPLEPGPENCRYPTBUFFER_KEYSELCANCEL:
		case SIMPLEPGPSIGNBUFFER_KEYSELCANCEL:
		case SIMPLEPGPOPENPUBLICKEYRING_USERCANCELONTASKBUSY:
		case SIMPLEPGPOPENPRIVATEKEYRING_USERCANCELONTASKBUSY:
		// everything OK codes
		case KERNEL_EXIT_OK:
		case KERNEL_EXIT_OK_NOSIG:
			return FALSE;

		case KERNEL_INVALID_FILE_OP_ERROR:
			uIDS = IDS_ERR_INVALIDFILEOPERROR;
			break;

		case KERNEL_KEYRING_ADD_ERROR :
			uIDS = IDS_ERR_KEYADDERROR;
			break;

		case KERNEL_OUT_OF_MEM :
			uIDS = IDS_ERR_OUTOFMEMORY;
			break;

		case KERNEL_NONEXIST_KEY_ERROR :
		case SIMPLEPGP_NONEXISTENTRECIPIENTKEY :
			uIDS = IDS_ERR_KEYNOTEXIST;
			break;

		case SIMPLEPGP_NONEXISTENTSIGNERKEY :
			uIDS = IDS_ERR_SIGNKEYNOTEXIST;
			break;

		case SIMPLEPGP_NONEXISTENTEXTRACTIONKEY :
			uIDS = IDS_ERR_EXTRACTKEYNOTEXIST;
			break;

		case KERNEL_RSA_ENCR_ERROR:
		case SIMPLEPGP_ERRORREADINGPUBRING :
			uIDS = IDS_ERR_RSAENCRERROR;
			break;

		case SIMPLEPGP_RECIPIENTKEYSIGNATUREONLY :
			uIDS = IDS_ERR_SIGONLYKEY;
			break;

		case KERNEL_RSA_DECR_ERROR:
		case SIMPLEPGP_NONEXISTENTDECRYPTIONKEY :
			uIDS = IDS_ERR_RSADECRERROR;
			break;

		case SIMPLEPGP_DETACHEDSIGNATURENOTFOUND :
			uIDS = IDS_ERR_DETACHEDSIGNOTFOUND;
			break;

		case SIMPLEPGP_DETACHEDSIGNATUREFOUND :
			uIDS = IDS_ERR_DETSIGFOUND;
			break;

		case KERNEL_SIGNATURE_ERROR:
		case SIMPLEPGP_ERRORREADINGSECRING :
			uIDS = IDS_ERR_ERRORREADINGSECRING;
			break;

		case SIMPLEPGP_SIGNERKEYENCRYPTIONONLY :
			uIDS = IDS_ERR_ENCRYPTONLYKEY;
			break;

		case SIMPLEPGP_BADKEYPASSPHRASE :
			uIDS = IDS_ERR_WRONGKEYPASSPHRASE;
			break;

		case SIMPLEPGP_BADCONVENTIONALPASSPHRASE :
			uIDS = IDS_ERR_WRONGPASSPHRASE;
			break;

		case SIMPLEPGP_NOPGPDATA :
			uIDS = IDS_ERR_NOPGPDATA;
			break;

		case SIMPLEPGP_RNGNOTSEEDED :
			uIDS = IDS_ERR_RNGNOTSEEDED;
			break;

		case SIMPLEPGP_KEYRINGPERMISSIONS :
			uIDS = IDS_ERR_FILEPERMISSIONS;
			break;

//		case SIMPLEPGP_UNABLETOMATCHID:
//			uIDS = IDS_ERR_UNABLETOMATCHID;
//			break;

		case PGPCOMDLG_MEMERROR :
		case SIMPLEPGPADDKEY_NOTENOUGHMEMORYFORINPUTSTRUCTURE:
		case SIMPLEPGPANALYZEFILE_NOTENOUGHMEMORY :
		case SIMPLEPGPSIGNBUFFER_NOTENOUGHMEMORYFORINPUTSTRUCTURE:
		case SIMPLEPGPSIGNBUFFER_NOTENOUGHMEMORYFOROUTPUTSTRUCTURE:
		case SIMPLEPGPENCRYPTBUFFER_NOTENOUGHMEMORYFORINPUTSTRUCTURE:
		case SIMPLEPGPENCRYPTBUFFER_NOTENOUGHMEMORYFOROUTPUTSTRUCTURE:
		case SIMPLEPGPRECEIVEBUFFER_NOTENOUGHMEMORYFORINPUTSTRUCTURE:
		case SIMPLEPGPRECEIVEBUFFER_NOTENOUGHMEMORYFOROUTPUTSTRUCTURE:
		case SIMPLEPGPENCRYPTFILE_NOTENOUGHMEMORYFORINPUTSTRUCTURE :
//		case SIMPLEPGPEXTRACTKEY_NOTENOUGHMEMORYFORINPUTSTRUCTURE :
		case SIMPLEPGPEXTRACTKEY_NOTENOUGHMEMORYFOROUTPUTSTRUCTURE :
		case SIMPLEPGPRECEIVEFILE_NOTENOUGHMEMORYFORINPUTSTRUCTURE :
		case SIMPLEPGPSIGNFILE_NOTENOUGHMEMORYFORINPUTSTRUCTURE :
		case
SIMPLEPGPVERIFYDETACHEDSIGNATUREBUFFER_NOTENOUGHMEMORYFORINPUTDATASTRUCTURE :
		case
SIMPLEPGPVERIFYDETACHEDSIGNATUREFILE_NOTENOUGHMEMORYFORINPUTDATASTRUCTURE :
			uIDS = IDS_ERR_OUTOFMEMORY;
			break;

		case SIMPLEPGPRECEIVEBUFFER_INPUTBUFFERLENGTHISZERO :
		case SIMPLEPGPVERIFYDETACHEDSIGNATUREBUFFER_INPUTSIGBUFFERLENGTHISZERO :
		case
SIMPLEPGPVERIFYDETACHEDSIGNATUREBUFFER_INPUTDATABUFFERLENGTHISZERO :
		case SIMPLEPGPANALYZEBUFFER_BUFFERLENGTHISZERO :
			uIDS = IDS_ERR_DECRYPTINPUTBUFFEREMPTY;
			break;

		case SIMPLEPGPENCRYPTBUFFER_INPUTBUFFERLENGTHISZERO :
		case SIMPLEPGPSIGNBUFFER_INPUTBUFFERLENGTHISZERO :
			uIDS = IDS_ERR_ENCRYPTINPUTBUFFEREMPTY;
			break;

		case SIMPLEPGPKEYSEL_KEYRINGFILENOTFOUND:
			uIDS = IDS_ERR_KEYRINGFILENOTFOUND;
			break;

		case SIMPLEPGPENCRYPTFILE_INPUTFILEDOESNOTEXIST :
		case SIMPLEPGPANALYZEFILE_FILENAMEDOESNOTEXIST :
		case SIMPLEPGPADDKEY_INPUTFILENAMEDOESNOTEXIST :
		case SIMPLEPGPRECEIVEFILE_INPUTFILEDOESNOTEXIST :
		case SIMPLEPGPSIGNFILE_INPUTFILEDOESNOTEXIST :
		case SIMPLEPGPVERIFYDETACHEDSIGNATUREFILE_INPUTDATAFILEDOESNOTEXIST :
		case SIMPLEPGPVERIFYDETACHEDSIGNATUREFILE_INPUTSIGFILEDOESNOTEXIST :
			uIDS = IDS_ERR_INPUTFILENOTEXIST;
			break;

		case SIMPLEPGPENCRYPTFILE_OUTPUTFILECREATIONERROR :
		case SIMPLEPGPEXTRACTKEY_OUTPUTFILECREATIONERROR :
		case SIMPLEPGPSIGNFILE_OUTPUTFILECREATIONERROR :
			uIDS = IDS_ERR_CANNOTOPENOUTPUTFILE;
			break;

		case SIMPLEPGPRECEIVEBUFFER_OUTPUTBUFFERTOOSMALL :
		case SIMPLEPGPEXTRACTKEY_OUTPUTBUFFERTOOSMALL :
			uIDS = IDS_ERR_OUTPUTBUFFERTOOSMALL;
			break;

		case SIMPLEPGPADDKEY_OTHERINSTANCERUNNING :
			uIDS = IDS_ERR_OTHERINSTANCE;
			break;

//		case SIMPLEPGPSIGNBUFFER_FUNCTIONNOTENABLED:
//		case SIMPLEPGPRECEIVEBUFFER_FUNCTIONNOTENABLED:
//		case SIMPLEPGPENCRYPTBUFFER_ENCRYPTNOTSIGN_FUNCTIONNOTENABLED:
//		case SIMPLEPGPENCRYPTBUFFER_ENCRYPTANDSIGN_FUNCTIONNOTENABLED:
//			uIDS = IDS_ERR_FUNCTIONNOTENABLED;
//			break;

		case SIMPLEPGPSIGNBUFFER_CANNOTUSEUNCERTIFIEDKEY:
			uIDS = IDS_ERR_CANNOTSIGNWITHUNCERTIFIEDKEY;
			break;

		case SIMPLEPGPRECEIVEBUFFER_CANNOTUSEUNCERTIFIEDKEY:
			uIDS = IDS_ERR_CANNOTDECRYPTWITHUNCERTIFIEDKEY;
			break;

		case SIMPLEPGPENCRYPTBUFFER_CANNOTUSEUNCERTIFIEDKEY:
			uIDS = IDS_ERR_CANNOTENCRYPTWITHUNCERTIFIEDKEY;
			break;

		case SIMPLEPGPCHECKRECIPIENT_CANNOTUSEUNTRUSTEDKEY :
			uIDS = IDS_ERR_CANNOTUSEUNTRUSTEDKEY;

		case SIMPLEPGPRECEIVEBUFFER_ISKEY :
			uIDS = IDS_ERR_BUFFERISKEY;
			break;
			
		case PGPERR_KEYIO_SEEKING :
		case PGPERR_KEYIO_BADPKT :
		case PGPERR_KEYIO_READING :
		case PGPERR_KEYIO_EOF :
			uIDS = IDS_ERR_KEYRINGCORRUPT;
			break;

		case PGPCOMDLG_NOSECRETKEYS :
			uIDS = IDS_ERR_NOSECRETKEYS;
			break;

		case PGPCOMDLG_EXPIRED:
			uIDS = IDS_ERR_EXPIRED;
			break;

		default:
			uIDS = IDS_ERR_CATCHALL;
			break;
    }
	
	LoadString (g_hInst, uIDS, szString, uLen);
	if (uIDS == IDS_ERR_CATCHALL) {
		wsprintf (g_szbuf, szString, iCode);
		strncpy (szString, g_szbuf, uLen);
		szString[uLen-1] = '\0';
	}

	return TRUE;
}


//----------------------------------------------------|
//	putup error messagebox (if necessary)

BOOL PGPExport PGPcomdlgErrorMessage (INT iCode) {

	CHAR szMessage[G_BUFLEN];
	CHAR szCaption[64];

	if (PGPcomdlgErrorToString (iCode, szMessage, G_BUFLEN)) {
		LoadString (g_hInst, IDS_ERRORMESSAGECAPTION, szCaption,
								sizeof(szCaption));
		MessageBox (NULL, szMessage, szCaption,
						MB_OK|MB_ICONSTOP|MB_SETFOREGROUND);
		return TRUE;
	}
	return FALSE;
}



//----------------------------------------------------|
//	convert signature result code to message string

BOOL PGPExport PGPcomdlgTranslateSignatureResult (
							INT iSignatureCode, LPSTR szSigner,
							LPSTR szSignatureDate,
							LPSTR szMessageBuffer, UINT uBufferLen) {

	CHAR* sz;
	UINT u;

	u = lstrlen (szSignatureDate) + lstrlen (szSigner) + 256;
	sz = HeapAlloc (GetProcessHeap (), 0, u);
	if (!sz) return FALSE;
	sz[0] = '\0';

	switch (iSignatureCode) {
	     case SIGSTS_VERIFIED_UNTRUSTED:
			LoadString (g_hInst, IDS_SIG_VERUNTRUSTED, g_szbuf, G_BUFLEN);
			wsprintf (sz, g_szbuf, szSigner);
			lstrcat (sz,"\n");
			//Fall through

		case SIGSTS_VERIFIED:
			LoadString (g_hInst, IDS_SIG_VERIFIED, g_szbuf, G_BUFLEN);
			u = lstrlen (sz);
			wsprintf (&sz[u], g_szbuf, szSigner, szSignatureDate);
			break;

		case SIGSTS_NOTVERIFIED:
			LoadString (g_hInst, IDS_SIG_NOTVERIFIED, sz, u);
			break;

		case SIGSTS_BADSIG:	
			if (*szSigner) {
				LoadString (g_hInst, IDS_SIG_BADSIG, g_szbuf, G_BUFLEN);
				wsprintf (sz, g_szbuf, szSigner);
			}
			else
				LoadString (g_hInst, IDS_SIG_UNVERIFIABLE, sz, u);

			if (*szSignatureDate) {
				LoadString (g_hInst, IDS_SIG_DATESTRING, g_szbuf, G_BUFLEN);
				u = lstrlen (sz);
				wsprintf (&sz[u], g_szbuf, szSignatureDate);
			}
			break;
	}

	strncpy (szMessageBuffer, sz, uBufferLen);
	szMessageBuffer [uBufferLen-1] = '\0';
	HeapFree (GetProcessHeap (), 0, sz);

	if (*szMessageBuffer) return TRUE;
	return FALSE;
}
