#include <stdio.h>
#include <unistd.h>
#include "client.h"
#include "des.h"

/* Make a withdrawal from a wallet */

int lucre_withdraw(EC_W_Wallet wallet, UInt32 amount, UInt32 minpayments)
{
    EC_M_Msg		msg = NULL;
    EC_Errno		err;
    char		pwbuf[1000];
    char		amtstr[80];
    int			res;
    sockfd		sfd = NULL;
    int			ret = -1;

    if (!wallet) return -1;

    /* Is this sensible? */
    if (wallet->userrec->userID == 0) {
	/* There's no bank account from which to withdraw! */
	printf("Cannot withdraw without bank account.\n");
	return -1;
    }

    /* Try to get a password */
    if (!wallet->userprivkey) {
	/* Try no password */
	EC_W_wallet_usephrase(wallet, "");
	if (!wallet->userprivkey) {
	    printf("Enter wallet pass phrase to unlock your private key.\n");
	    fflush(stdout);
	    res = des_read_pw_string(pwbuf, sizeof(pwbuf) - 1,
					"Pass phrase: ", 0);
	    CHECK(read_pw_string, res);
	    err = EC_W_wallet_usephrase(wallet, pwbuf);
	    if (err) {
		printf("Bad password.  Aborting.\n");
		return -1;
	    }
	}
    }

    /* Connect to the bank */
    sfd = bank_socket(wallet);
    CHECK(bank_socket, !sfd);

    /* Do the withdrawal protocol */
    msg = EC_M_new_msg();
    CHECK(new_msg, !msg);
    err = EC_W_withdraw_1(wallet, msg, amount, minpayments);
    CHECK(withdraw_1, err);
    err = sfd->write(sfd, msg);
    CHECK(encode, err);
    EC_M_clear_msg(msg);
    err = sfd->read(sfd, msg);
    CHECK(decode, err);
    err = EC_W_withdraw_2(wallet, msg, &amount);
    CHECK(withdraw_2, err);
    EC_U_curramt2str(wallet->userrec->currency, amount, amtstr,
	sizeof(amtstr));
    printf("Received %s from mint\n", amtstr);
    ret = 0;

clean:
    EC_M_free_msg(msg);
    if (sfd) sfd->close(sfd);

    return ret;
}
