#include <stdio.h>
#include <string.h>
#include <time.h>
#include "client.h"

/* Show the number, demonimation, and expiry time of each coin in the wallet */
int lucre_show_contents(EC_W_Wallet wallet)
{
    EC_W_Tally tally;
    EC_Errno err = EC_ERR_NONE;
    UInt32 v;
    UInt32 cumval = 0;
    UInt32 cumamt = 0;
    char cumvalstr[40];
    EC_M_Status status;
    EC_W_Locktype oldlock;

    /* Get the tally */
    tally = EC_W_new_tally();
    if(!tally) return -1;

    err = EC_W_cashdb_tally(wallet, wallet->userrec->bankID,
	wallet->userrec->currency, 0, EC_W_TALLY_NONE, tally);
    if (err) {
	EC_W_free_tally(tally);
	return -1;
    }

    printf("\nCoins currently in wallet:\n\n"
      "       Coin value  Number   Expiry date                  Total value\n"
      "  ------------------------------------------------------------------\n"
    );
    /* Walk through it */
    for(v=0;v<tally->numvers;++v) {
	/* For each keyversion, get the curr record */
	UInt32 baseval;
	char expirystr[40];
	char *nl;
	UInt32 d;
	EC_M_Curr curr = EC_W_curr_lookup(wallet, wallet->userrec->bankID,
	    wallet->userrec->currency, tally->ver[v].keyversion);
	if (!curr) continue;

	/* Get the baseval and expiry time */
	baseval = curr->cinfo[0]->base_val;
	strcpy(expirystr, ctime(&(curr->cinfo[0]->expire_time)));
	nl = strchr(expirystr, '\n');
	if (nl) *nl = '\0';
	EC_M_free_curr(curr);

	/* Now go through each denomination */
	for(d=0;d<tally->ver[v].ndenom;++d) {
	    UInt32 nc = tally->ver[v].ncoins[d];
	    UInt32 coinval = (1<<d) * baseval;
	    char coinvalstr[21];
	    char totvalstr[21];
	    if (nc == 0) continue;

	    /* Construct the string versions of the values */
	    EC_U_curramt2str(wallet->userrec->currency, coinval,
		coinvalstr, sizeof(coinvalstr));
	    EC_U_curramt2str(wallet->userrec->currency, nc*coinval,
		totvalstr, sizeof(totvalstr));
	    printf("  %15s %7d   %s %15s\n", coinvalstr, nc, expirystr,
		    totvalstr);
	    
	    /* Keep a running total */
	    cumval += nc*coinval;
	    cumamt += nc*(1<<d);
	}
    }

    /* Show the total */
    printf(
      "  ==================================================================\n"
    );
    strcpy(cumvalstr, "Total: ");
    EC_U_curramt2str(wallet->userrec->currency, cumval, cumvalstr+7,
			sizeof(cumvalstr)-7);
    printf("%68s\n", cumvalstr);

    EC_W_free_tally(tally);

    /* Now try to update the cash-on-hand */
    err = EC_W_wallet_templock(wallet, EC_W_LOCK_WRITE_NOWAIT, &oldlock);
    if (err) return 0;

    status = EC_W_status_read(wallet);
    if (status) {
	status->cash = cumamt;
	EC_W_status_write(wallet, status);
	EC_M_free_status(status);
    }

    EC_W_wallet_lock(wallet, oldlock);

    return 0;
}
