#ifndef __CLIENT_H__
#define __CLIENT_H__

#include "lucre.h"

#define CHECK(fcn,tst) do { if (tst) { puts("Error in "#fcn); goto clean; } } while(0)

typedef enum {
    SOCKFD_DIRECT_TCP,
    SOCKFD_HTTP,
    SOCKFD_HTTP_SSL,
} SockfdType;

typedef struct sockfd_s {
    SockfdType kind;
    EC_Errno (*write)(struct sockfd_s *sockfd, EC_M_Msg msg);
    EC_Errno (*read)(struct sockfd_s *sockfd, EC_M_Msg msg);
    void (*close)(struct sockfd_s *sockfd);
    void *data;
} * sockfd;

int make_socket(char *host, unsigned short port);
sockfd bank_socket(EC_W_Wallet wallet);
EC_Errno create_moneychangers_block(EC_W_Wallet wallet, EC_M_Msg msg);
int parse_moneychangers_block(EC_W_Wallet wallet, EC_M_Msg msg);

int make_listen(unsigned short port);
void strcpy_strip(char *dest, char *src);
int lucre_openacc(char *walletid, char *walletpp, char *accID, char *accpw,
    char *mint_addr, unsigned short mint_port, EC_M_Currency currency);
int lucre_withdraw(EC_W_Wallet wallet, UInt32 amount, UInt32 minpayments);
int lucre_deposit_cash(EC_W_Wallet wallet, UInt32 amount);
int lucre_deposit_payment(EC_W_Wallet wallet, EC_M_Msg msg,
    EC_M_Payment *payment, EC_M_Depflags depflags);
int lucre_pay(EC_W_Wallet wallet, int amount, char *shop, char *descr);
int lucre_getpay_fd(EC_W_Wallet wallet, int payfd, int armor);
int lucre_getpay(EC_W_Wallet wallet);
int lucre_reqpay(EC_W_Wallet wallet, int amount, char *descr);
int lucre_expreq(EC_W_Wallet wallet);
int lucre_balance(EC_W_Wallet wallet);
int lucre_passwd(EC_W_Wallet wallet);
int lucre_list_payments(EC_W_Wallet wallet, UInt32 from, UInt32 to);
int lucre_cancel_payment(EC_W_Wallet wallet, UInt32 seqno);
int lucre_show_contents(EC_W_Wallet wallet);
int lucre_moneychangers_block_parse(EC_W_Wallet wallet, char *mfilename);
int lucre_moneychangers_block_create(EC_W_Wallet wallet, char *mfilename);

#endif
