/* t_print.c */


/*#include "ecashlib.h"*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "t_print.h"



void dprint(const char *message_str)
{
	fprintf(stdout, message_str);

	return;
} /* dprint */

void test_yield(int this_is_the_last_yield)
{
	if (this_is_the_last_yield == 0) {
		dprint("Yo! ");
	} else if (this_is_the_last_yield == 1) {
		dprint("Oy!\n");
	} else {
		dprint("BWAH?\n\n\n");
	}

	return;
} /* test_yield */

void test_log(EC_LogLevel level, const char *text_str)
{
	static FILE *log_FILE_ptr = NULL;

	if (log_FILE_ptr == NULL) {
		log_FILE_ptr = fopen("log.out", "w+");
	}

	fprintf(log_FILE_ptr, "LogLevel = %d -- ", level);
	fprintf(log_FILE_ptr, "%s", text_str);

	fflush(log_FILE_ptr);

	if (strcmp(text_str, "Close the log file now.") == 0) {
		fclose(log_FILE_ptr);
	}

	return;
} /* test_log */

void test_print_accID(const EC_AccountID *accID_lnk)
{
	Char *acct_name_str = NULL;

	acct_name_str = EC_accID_get_acct_name(accID_lnk);

	printf("        mintID: %ld\n", EC_accID_get_mintID(accID_lnk));
	printf("        acct_name: \"%s\"\n", acct_name_str);

	free(acct_name_str);

	return;
} /* test_print_accID */

void test_print_array(Byte *array_ptr, UInt32 size)
{
	UInt32 local_index = 0;

	for (local_index = 0; local_index < size; local_index++) {
		printf("%c", array_ptr[local_index]);
	}

	return;
} /* test_print_array */

void test_print_coinage(const EC_Coinage *coinage_lnk)
{
	printf("        mintID: %ld\n", EC_coinage_get_mintID(coinage_lnk));
	printf("        currID: %ld\n", EC_coinage_get_currID(coinage_lnk));
	printf("        base_magn: %ld\n", EC_coinage_get_base_magn(coinage_lnk));
	printf("        base_factor: %ld\n", EC_coinage_get_base_factor(coinage_lnk));
	printf("        granularity: %ld\n", EC_coinage_get_granularity(coinage_lnk));

	return;
} /* test_print_coinage */

void test_print_addr(const EC_Address *addr_lnk)
{
	UInt32 size = 0;
	Byte *contents_ptr = NULL;

	size = EC_addr_get_size(addr_lnk);
	contents_ptr = EC_addr_get_contents(addr_lnk);

	printf("        size: %d\n", size);
	printf("        contents: ");

	test_print_array(contents_ptr, size);

	printf("\n");

	free(contents_ptr);

	return;
} /* test_print_addr */

void test_print_info(const EC_Info *info_lnk)
{
	EC_AccountID *accID_ptr = NULL;
	Char *acct_info_str = NULL;
	EC_AccountStatus acct_status = EC_ACCOUNTSTATUS_INVALID;
	EC_MintID mintID = EC_MINTID_INVALID;
	Char *mint_info_str = NULL;
	EC_Address *mint_addr_ptr = NULL;
	EC_Coinage *coinage_ptr = NULL;
	EC_Amount cash = 6666;
	EC_Amount balance = 7777;
	EC_Amount exp_cash = 8888;
	UInt32 min_payments = 9999;

	accID_ptr = EC_info_get_accID(info_lnk);
	printf("accID: {\n");
	test_print_accID(accID_ptr);
	printf("}\n");
	EC_accID_free(accID_ptr);

	acct_info_str = EC_info_get_account_info(info_lnk);
	printf("acct_info_str: \"%s\"\n", acct_info_str);

	acct_status = EC_info_get_acct_status(info_lnk);
	printf("acct_status: %d\n", acct_status);

	mintID = EC_info_get_mintID(info_lnk);
	printf("mintID: %ld\n", mintID);

	mint_info_str = EC_info_get_mint_info(info_lnk);
	printf("mint_info_str: \"%s\"\n", mint_info_str);

	mint_addr_ptr = EC_info_get_mint_addr(info_lnk);
	printf("mint_addr: {\n");
	test_print_addr(mint_addr_ptr);
	printf("}\n");
	EC_addr_free(mint_addr_ptr);

	coinage_ptr = EC_info_get_coinage(info_lnk);
	printf("coinage: {\n");
	test_print_coinage(coinage_ptr);
	printf("}\n");
	EC_coinage_free(coinage_ptr);

	cash = EC_info_get_cash(info_lnk);
	printf("cash: %ld\n", cash);

	balance = EC_info_get_balance(info_lnk);
	printf("balance: %ld\n", balance);

	exp_cash = EC_info_get_exp_cash(info_lnk);
	printf("exp_cash: %ld\n", exp_cash);

	min_payments = EC_info_get_min_payments(info_lnk);
	printf("min_payments: %d\n", min_payments);

	return;
} /* test_print_info */

