#ifndef EC_INCL_EECDEF_H
#define EC_INCL_EECDEF_H
/* beginning of eecdef.h */

/************************************************************************
*									*
* eecdef.h								*
*									*
* Common macros and typedefs that need to be included into each         *
* Ecash(tm) program.                                                    *
*									*
************************************************************************/

/* 
 * Here is our platform specific stuff.  Hopefully this will work
 * on your platform just by #define'ing the proper flag.  If not, let
 * us know.  If there is not a flag here for your platform then 
 * hopefully you can do without one!  (This is, after all, a pure 
 * ANSI C library plus support for Windows DLL's.)
 */


/* 
 * Platform-identification flags:
 *
 * "_Windows" -- Windows 16 or 32 bit or Windows NT (the only reason for this
 *	flag is to enable Windows DLL's-- see below.)
 *
 * "__alpha" -- DEC Alpha CPU architecture (the only reason for this flag is 
 *	to correctly identify a 32-bit data type (an Alpha "int")-- see below.)
 */

#ifdef _WINDOWS
#include <windows.h>

#ifdef WIN32
#define EC_EXPORT __declspec(dllexport)
#else
#define EC_EXPORT WINAPI
#endif

/*
 * Define "EC_EXPORT" to be a keyword your platform needs to make a 
 * function available for linking.  To make a Windows DLL, for  
 * example, define it to be "WINAPI".  
 */


#else /* #ifdef _WINDOWS */
#define EC_EXPORT
#endif


#ifndef EC_EXPORT
#define EC_EXPORT
#endif


typedef long Long;
typedef unsigned long ULong;
typedef short Short;
typedef unsigned short UShort;
typedef int Int;
typedef unsigned int UInt;
typedef char Char;
typedef unsigned char Byte;


#undef EC_MAXLONG
#define EC_MAXLONG (2 << --(sizeof(Long) * 8))L
#undef EC_MINLONG
#define EC_MINLONG ++(-1 * (2 << --(sizeof(Long) * 8)))L

#undef EC_MAXULONG
#define EC_MAXULONG ((2 << (sizeof(Long) * 8)) -1)L

#undef EC_MAXSHORT
#define EC_MAXSHORT (2 << --(sizeof(Short) * 8))L
#undef EC_MINSHORT
#define EC_MINSHORT ++(-1 * (2 << --(sizeof(Short) * 8)))L

#undef EC_MAXUSHORT
#define EC_MAXUSHORT ((2 << (sizeof(Short) * 8)) -1)L

#undef EC_MAXINT
#define EC_MAXINT (2 << --(sizeof(Int) * 8))L
#undef EC_MININT
#define EC_MININT ++(-1 * (2 << --(sizeof(Int) * 8)))L

#undef EC_MAXUNIT
#define EC_MAXUINT ((2 << (sizeof(Int) * 8)) -1)L

#undef EC_MAXCHAR
#define EC_MAXCHAR (2 << --(sizeof(Char) * 8))L
#undef EC_MINCHAR
#define EC_MINCHAR ++(-1 * (2 << --(sizeof(Char) * 8)))L

#undef EC_MAXBYTE
#define EC_MAXBYTE (2 << (sizeof(Byte) * 8)L



typedef short Int16;
typedef unsigned short UInt16;


#ifdef __alpha
typedef int Int32;
typedef unsigned int UInt32;
#else
typedef long Int32;
typedef unsigned long UInt32;
#endif


#undef EC_MAXINT16
#define EC_MAXINT16 (Int16)32768
#undef EC_MININT16
#define EC_MININT16 (Int16)-32767

#undef EC_MAXUINT16
#define EC_MAXUINT16 (UInt16)65535

#undef EC_MAXINT32
#define EC_MAXINT32 (Int32)2147483648L
#undef EC_MININT32
#define EC_MININT32 (Int32)-2147483647L

#undef EC_MAXUINT32
#define EC_MAXUINT32 (UInt32)4294967295L




#define EC_MINTID_INVALID 0L /* it is supposed to be an error if you ask for
	an EC_MintID and you get this. */
#define EC_MINTID_UNKNOWN 1L

#define EC_CURRID_INVALID 0L /* it is supposed to be an error if you ask for
	an EC_CurrencyID and you get this. */
#define EC_CURRID_UNKNOWN 1L

#define EC_MINPAYMENTS_INVALID EC_MAXUINT16 /* it is supposed to be an error
	if you ask for "minimum payments" and get this. */

#define EC_ACCID_NONE "There is no EC_AccountID present.  This probably indicates an error in the program."

#define EC_MINTINFO_NONE "There is no information about this mint available yet.  This is probably because your Ecash(tm) client has not communicated with the mint yet."

	/*!! note that the base_magnitude, base_factor, and granularity are 
	just hardcoded here for now.  Should be fixed-- either transmit this 
	data in the setup message or have a table mapping mintID/currency 
	pairs onto base_magnitude, base_factor, granularity triplets. */

#define EC_COINAGE_BASE_MAGNITUDE_DEFAULT -2
#define EC_COINAGE_BASE_FACTOR_DEFAULT 1
#define EC_COINAGE_GRANULARITY_DEFAULT -2



/* end of eecdef.h */
#endif
