// 
// VXD.H -- Additional 'C' Macros for VxD Construction
//
//  Stan Mitchell, 1995
//

#ifndef _VXD_H_
#define _VXD_H_

#define offsetof(s,m)   (int)&(((s *)0)->m)
#define SegOfs(s)       offsetof(CRS,Client_##s)
#define RegOfs(w)       offsetof(struct Client_Word_Reg_Struc,Client_##w)

#define     LOCAL_CLIENT_REG_FRAME( var ) \
    _asm    pushad                        \
    _asm    mov eax,ebp                   \
    _asm    mov ebp,esp                   \
    _asm    sub esp,__LOCAL_SIZE          \
    _asm    mov [var],eax

#define     PUSHALL_FRAME()               \
    _asm    pushad                        \
    _asm    mov ebp,esp                   \
    _asm    sub esp,__LOCAL_SIZE

#define     CLOSE_FRAME()   \
    _asm    mov esp,ebp     \
    _asm    popad

// Macros for defining Win95 Hook procedures
#define     HOOKPROC            void __declspec( naked )

// These two jumps make up the hook preamble
// These are needed to support Unhook_Device_Service
// The real hook procedure begins after these at "real_entry"
#define     HOOK_PREAMBLE(prev)             \
            _asm    jmp short real_entry    \
            _asm    jmp dword ptr prev      \
            _asm    real_entry:

typedef char *PSTR;

#define     SYSCTRL_CALLBACK    __stdcall

// System Control Message Handlers
int SYSCTRL_CALLBACK CtrlMsg_Sys_VM_Init( HVM hSysVM );
int SYSCTRL_CALLBACK CtrlMsg_Sys_VM_Terminate( HVM hSysVM );
int SYSCTRL_CALLBACK CtrlMsg_System_Exit( HVM hSysVM );
int SYSCTRL_CALLBACK CtrlMsg_Sys_Crit_Init( HVM hSysVM, PCHAR pCmdTail );
int SYSCTRL_CALLBACK CtrlMsg_Device_Init( HVM hSysVM, PCHAR pCmdTail );
int SYSCTRL_CALLBACK CtrlMsg_Init_Complete( HVM hSysVM, PCHAR pCmdTail );
int SYSCTRL_CALLBACK CtrlMsg_DynDeviceInit( void );
int SYSCTRL_CALLBACK CtrlMsg_DynDeviceExit( void );
int SYSCTRL_CALLBACK CtrlMsg_W32DeviceIoControl( int service,
                            PDIOCPARAMETERS pDIOCParams );
int SYSCTRL_CALLBACK CtrlMsg_Create_VM( HVM hNewVM );
int SYSCTRL_CALLBACK CtrlMsg_Create_Thread( PTCB hNewThread );
int SYSCTRL_CALLBACK CtrlMsg_VM_Init( HVM hVM );
int SYSCTRL_CALLBACK CtrlMsg_VM_Suspend( HVM hVM );
int SYSCTRL_CALLBACK CtrlMsg_VM_Resume( HVM hVM );
int SYSCTRL_CALLBACK CtrlMsg_Destroy_VM( HVM hDeadVM );
int SYSCTRL_CALLBACK CtrlMsg_Destroy_Thread( PTCB hDeadThread );
int SYSCTRL_CALLBACK CtrlMsg_Kernel32_Init( void );
int SYSCTRL_CALLBACK CtrlMsg_Debug_Query( void );
int SYSCTRL_CALLBACK CtrlMsg_Begin_PM_App( HVM hSysVM, DWORD flags, struct pmcb_s* pPMCB );

/* System Control Message dispatch macros
 * --------------------------------------
 *  - arguments are passed in registers
 *  - handler functions use __stdcall calling convention
 */

#define     BEGIN_DISPATCH_MAP

#define     END_DISPATCH_MAP                \
    _asm end_dispatch:                      \
    _asm cmp eax,1                          \
    _asm ret

#define     ON_DEFAULT()                    \
    _asm clc                                \
    _asm ret

#define ON_SYS_CRITICAL_INIT( fn )          \
    _asm cmp eax,SYS_CRITICAL_INIT          \
    _asm jnz skip_sys_crit                  \
    _asm push esi                           \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_sys_crit:                     
                                            
#define ON_DEVICE_INIT( fn )                \
    _asm cmp eax,DEVICE_INIT                \
    _asm jnz skip_dev_init                  \
    _asm push esi                           \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_dev_init:                     
                                            
#define ON_INIT_COMPLETE( fn )              \
    _asm cmp eax,INIT_COMPLETE              \
    _asm jnz skip_init_complete             \
    _asm push esi                           \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_init_complete:
        
#define ON_SYS_VM_INIT( fn )                \
    _asm cmp eax,SYS_VM_INIT                \
    _asm jnz skip_sys_vm_init               \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_sys_vm_init:

#define ON_SYSTEM_EXIT( fn )                \
    _asm cmp eax,SYSTEM_EXIT                \
    _asm jnz skip_system_exit               \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_system_exit:

#define ON_SYS_VM_TERMINATE( fn )           \
    _asm cmp eax,SYS_VM_TERMINATE           \
    _asm jnz skip_sys_vm_term               \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_sys_vm_term:

#define ON_SYS_DYNAMIC_DEVICE_INIT( fn )    \
    _asm cmp eax,SYS_DYNAMIC_DEVICE_INIT    \
    _asm jnz skip_dyn_dev_init              \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_dyn_dev_init:

#define ON_SYS_DYNAMIC_DEVICE_EXIT( fn )    \
    _asm cmp eax,SYS_DYNAMIC_DEVICE_EXIT    \
    _asm jnz skip_dyn_dev_exit              \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_dyn_dev_exit:

#define ON_CREATE_THREAD( fn )              \
    _asm cmp eax, CREATE_THREAD             \
    _asm jnz skip_create_thread             \
    _asm push edi                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_create_thread:

#define ON_DESTROY_THREAD( fn )             \
    _asm cmp eax, DESTROY_THREAD            \
    _asm jnz skip_destroy_thread            \
    _asm push edi                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_destroy_thread:

#define ON_CREATE_VM( fn )                  \
    _asm cmp eax, CREATE_VM                 \
    _asm jnz skip_create_vm                 \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_create_vm:

#define ON_VM_INIT( fn )                    \
    _asm cmp eax,VM_INIT                    \
    _asm jnz skip_vm_init                   \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_vm_init:

#define ON_VM_SUSPEND( fn )                 \
    _asm cmp eax,VM_SUSPEND                 \
    _asm jnz skip_vm_suspend                \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_vm_suspend:

#define ON_VM_RESUME( fn )                  \
    _asm cmp eax,VM_RESUME                  \
    _asm jnz skip_vm_resume                 \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_vm_resume:

#define ON_DESTROY_VM( fn )                 \
    _asm cmp eax, DESTROY_VM                \
    _asm jnz skip_destroy_vm                \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_destroy_vm:

#define ON_W32_DEVICEIOCONTROL( fn )        \
    _asm cmp eax,W32_DEVICEIOCONTROL        \
    _asm jnz skip_w32_ctrl                  \
    _asm push esi                           \
    _asm push ecx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_w32_ctrl:

#define ON_DIRECTED( num, fn )              \
    _asm cmp eax,num                        \
    _asm jnz skip##num                      \
    _asm push ebx                           \
    _asm push ecx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip##num:

#define ON_DIRECTED0( num, fn )             \
    _asm cmp eax,num                        \
    _asm jnz skip##num                      \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip##num:

#define ON_DIRECTED1( num, fn )             \
    _asm cmp eax,num                        \
    _asm jnz skip##num                      \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip##num:

#define ON_DIRECTED2( num, fn )             \
    _asm cmp eax,num                        \
    _asm jnz skip##num                      \
    _asm push edx                           \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip##num:

#define ON_DEBUG_QUERY( fn )                \
    _asm cmp eax,DEBUG_QUERY                \
    _asm jnz skip_debq                      \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_debq:

#define ON_KERNEL32_INITIALIZED( fn )       \
    _asm cmp eax, KERNEL32_INITIALIZED      \
    _asm jnz skip_krnl32_init               \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_krnl32_init:

#define ON_BEGIN_PM_APP( fn )               \
    _asm cmp eax, BEGIN_PM_APP              \
    _asm jnz skip_begin_pm_app              \
    _asm push edi                           \
    _asm push edx                           \
    _asm push ebx                           \
    _asm call fn                            \
    _asm jmp end_dispatch                   \
    _asm skip_begin_pm_app:

#ifndef IFSMGR_INIT_ORDER
#define IFSMGR_INIT_ORDER   0x10000 + V86MMGR_INIT_ORDER
#define FSD_INIT_ORDER      0x00100 + IFSMGR_INIT_ORDER
#endif

// Declare Device Descriptor Block
#define Declare_DDB( name, major, minor, dispatch,      \
                     devID, init, v86proc, pmproc,      \
                     refdata, svctbl, numsvcs )         \
    struct VxD_Desc_Block                               \
        DDB = {  0, DDK_VERSION, devID,                 \
                 major, minor, 0, name,                 \
                 init, (DWORD)dispatch,                 \
                 (DWORD)v86proc, (DWORD)v86proc, 0, 0,  \
                 refdata, svctbl, numsvcs, 0, 'Prev',   \
                 sizeof( struct VxD_Desc_Block ),       \
                 'Rsv1', 'Rsv2', 'Rsv3' };


typedef struct { DWORD dwOffset; WORD wSelector; } PTR48;
typedef struct { WORD wOfs; WORD wSel; } PTR32;

// Offsets to members of the Client Register Structure
//  ---
// 	The inline assembler does not accept expressions like:
//		mov		ax,[ebp].Client_AX
//	so we need to use
//		mov		ax,[ebp+CLIENT_AX]
//	instead.
//  ---
#define	CLIENT_AX		0x1c	// bottom word of EAX
#define CLIENT_AL       0x1c
#define CLIENT_AH       0x1d    
#define	CLIENT_uAX		0x1e	// top word of EAX
#define	CLIENT_EFLAGS	0x2c
#define	CLIENT_ESP		0x30
#define	CLIENT_SS		0x34

#endif

/***************** end of file ******************/
