/* ssl_port.h    - standard porting things 
 *
 * The modifications to support SSLeay were done by Tim Hudson
 * tjh@mincom.oz.au
 *
 * You can do whatever you like with these patches except pretend that
 * you wrote them. 
 *
 * Email ssl-users-request@mincom.oz.au to get instructions on how to
 * join the mailing list that discusses SSLeay and also these patches.
 *
 */

#ifndef HEADER_SSL_PORT_H
#define HEADER_SSL_PORT_H

#ifdef USE_SSL

#include <stdio.h>
#include "ssl.h"
extern SSL *ssl_con;
extern int ssl_debug_flag;
extern int ssl_only_flag;
extern int ssl_active_flag;
extern int ssl_verify_flag;
extern int ssl_secure_flag;

extern int ssl_encrypt_data;
extern SSL *ssl_data_con;
extern int ssl_data_active_flag;

#define is_ssl_fd(X,Y)    ( (SSL_get_fd((X))==0) || \
                            (SSL_get_fd((X))==1) || \
			    (SSL_get_fd((X))==(Y)) \
			  )

#define is_ssl_fp(X,Y)    ( ( (SSL_get_fd((X))==0) && (fileno((Y))==0) ) || \
                            ( (SSL_get_fd((X))==1) && (fileno((Y))==1) ) || \
			    (SSL_get_fd((X))==fileno(Y)) \
			  )

extern int SSL_fprintf(SSL *ssl_con, FILE *fp, char *format, ... );

/* this cute macro makes things much easier to handle ... */
/* #define FPRINTF(A,X,Y,Z)    (ssl_active_flag && is_ssl_fp(ssl_con,(X))) ? SSL_fprintf(ssl_con,(Y),(Z)) : fprintf((X),(Y),(Z)) /**/
/* #define FFLUSH(X)         (ssl_active_flag && is_ssl_fp(ssl_con,(X))) ? 1 : fflush((X)) /**/

#define FPRINTF           SSL_fprintf
#define FFLUSH(X)         (ssl_active_flag && (((X)==cin)||((X)==cout)) ? 1 : fflush((X)) )

#define GETC(X)           (ssl_active_flag && (((X)==cin)||((X)==cout)) ? ssl_getc(ssl_con) : getc((X)) )

#define DATAGETC(X)       (ssl_data_active_flag && (fileno(X)==data) ? ssl_getc(ssl_data_con) : getc((X)) )
#define DATAPUTC(X,Y)     (ssl_data_active_flag && (fileno(Y)==data) ? ssl_putc(ssl_data_con,(X)) : putc((X),(Y)) )
#define DATAFLUSH(X)      (ssl_data_active_flag && (fileno(X)==data) ? ssl_putc_flush(ssl_data_con) : fflush((X)) )

#else

#define GETC(X)           getc((X))
#define DATAGETC(X)       getc((X))
#define DATAPUTC(X,Y)     putc((X),(Y))
#define DATAFLUSH(X)      fflush((X))

#endif /* USE_SSL */

#endif /*  HEADER_SSL_PORT_H */
