/*
**	ssh_errno.h	-- header file to handle error information
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_ERRNO_H
#define __SSH_ERRNO_H

/*
**	ssh_errno values and their corresponding strings
*/

#define SSH_ERRNO_LEN		100

#define SSH_ERRNO_UNKNOWN	-1
#define SSH_ERRNO_UNKNOWN_MSG	"Unknown SSH Protocol Level Error"

#define SSH_ERRNO_NONE		0
#define SSH_ERRNO_NONE_MSG	"No SSH Protocol Level Error"

#define SSH_ERRNO_LOW_MEM	1
#define SSH_ERRNO_LOW_MEM_MSG	"Not Enough Memory Allocated"

#define SSH_ERRNO_MSG_PARSE	2
#define SSH_ERRNO_MSG_PARSE_MSG	"Error Parsing Message from Remote Host"

#define SSH_ERRNO_RECV		3
#define SSH_ERRNO_RECV_MSG	"Error on Receiving Packet"

#define SSH_ERRNO_SEND		4
#define SSH_ERRNO_SEND_MSG	"Error on Sending Packet"

#define SSH_ERRNO_PROTO_PARSE		5
#define SSH_ERRNO_PROTO_PARSE_MSG	"Error Parsing Protocol Information"

#define SSH_ERRNO_BAD_CRC		6
#define SSH_ERRNO_BAD_CRC_MSG		"CRC Error in Packet"

#define SSH_ERRNO_PASSWD_FAILED		7
#define SSH_ERRNO_PASSWD_FAILED_MSG	"Password Authentication Failed"

#define SSH_ERRNO_AUTH			8
#define SSH_ERRNO_AUTH_MSG		"Authentication Failed"

#define SSH_ERRNO_USER			9
#define SSH_ERRNO_USER_MSG		"Sending User Information Failed"

#define SSH_ERRNO_UNKNOWN_CIPHER	10
#define SSH_ERRNO_UNKNOWN_CIPHER_MSG	"Cipher Type not Implemented"

#define SSH_ERRNO_VERSIONS		11
#define SSH_ERRNO_VERSIONS_MSG		"SSH Versions do not Match"

#define SSH_ERRNO_TYPE			12
#define SSH_ERRNO_TYPE_MSG		"Unexpected SSH Message Type"

#define SSH_ERRNO_MALLOC		13
#define SSH_ERRNO_MALLOC_MSG		"Error malloc\'ing Memory"

#define SSH_ERRNO_TODO			14
#define SSH_ERRNO_TODO_MSG		"TODO Section of the Code"

#define SSH_ERRNO_FINDCIPHER		15
#define SSH_ERRNO_FINDCIPHER_MSG	"Incompatible Supported Ciphers"

#define SSH_ERRNO_INIT_CIPHER		16
#define SSH_ERRNO_INIT_CIPHER_MSG	"Error Initializing Cipher Keys"

#define SSH_ERRNO_DISCONNECTED		17
#define SSH_ERRNO_DISCONNECTED_MSG	"Disconnected From Server"

#define SSH_ERRNO_AUTHMODE		18
#define SSH_ERRNO_AUTHMODE_MSG		"Authentication Mode Rejected"

#define SSH_ERRNO_IDENTITY_FILE		19
#define SSH_ERRNO_IDENTITY_FILE_MSG	"Unable to Open RSA Identity File"

#define SSH_ERRNO_IDENTITY_MISC		20
#define SSH_ERRNO_IDENTITY_MISC_MSG	"Misc. Error with Identity File"

#define SSH_ERRNO_ID_STRING		21
#define SSH_ERRNO_ID_STRING_MSG		"Error in header of Identity File"

#define SSH_ERRNO_IDENTITY_DECRYPT	22
#define SSH_ERRNO_IDENTITY_DECRYPT_MSG	"Invalid PassPhrase for RSA Identity"

#define SSH_ERRNO_RSA_FAILED		23
#define SSH_ERRNO_RSA_FAILED_MSG	"RSA Authentication Failed"

#define SSH_ERRNO_CHALLENGE_DECRYPT	24
#define SSH_ERRNO_CHALLENGE_DECRYPT_MSG	"Error Decrypting RSA Challenge"

#define SSH_ERRNO_IDENTITY_SAVE		25
#define SSH_ERRNO_IDENTITY_SAVE_MSG	"Error writing to identity file"

#define SSH_ERRNO_IDENTITY_LOAD		26
#define SSH_ERRNO_IDENTITY_LOAD_MSG	"Error reading identity file"

#define SSH_ERRNO_PHRASE_SHORT		27
#define SSH_ERRNO_PHRASE_SHORT_MSG	"Passphrase too short"

#define SSH_ERRNO_REQUEST_PTY		28
#define SSH_ERRNO_REQUEST_PTY_MSG	"Error receiving reply to pty request"

#define SSH_ERRNO_RANDOM_SEED		29
#define SSH_ERRNO_RANDOM_SEED_MSG	"Error seeding random number generator"

#define SSH_ERRNO_NULL_POINTER		30
#define SSH_ERRNO_NULL_POINTER_MSG	"NULL Pointer encountered"

#define SSH_ERRNO_PACKET_BIG		31
#define SSH_ERRNO_PACKET_BIG_MSG	"Trying to read or write a packet that is too big!"

#define SSH_ERRNO_COMPRESS_LEVEL	32
#define SSH_ERRNO_COMPRESS_LEVEL_MSG	"Invalid compression level"

#define SSH_ERRNO_REQUEST_COMPRESS	33
#define SSH_ERRNO_REQUEST_COMPRESS_MSG	"Error receiving reply to compression request"

#define SSH_ERRNO_ENCODE_MESSAGE	34
#define SSH_ERRNO_ENCODE_MESSAGE_MSG	"Error encoding SSH message"

#define SSH_ERRNO_ZLIB_MEM_ERROR	35
#define SSH_ERRNO_ZLIB_MEM_ERROR_MSG	"Not enough memory for the compression library"

#define SSH_ERRNO_ZLIB_STREAM_ERROR	36
#define SSH_ERRNO_ZLIB_STREAM_ERROR_MSG	"Compression library stream error"

#define SSH_ERRNO_ZLIB_VERSION_ERROR	37
#define SSH_ERRNO_ZLIB_VERSION_ERROR_MSG	"Compression library (ZLIB) versions do no match"

#define SSH_ERRNO_ZLIB_MISC		38
#define SSH_ERRNO_ZLIB_MISC_MSG		"Misc. Compression library (ZLIB) error"

#define SSH_ERRNO_COMPRESSION_WRONG	39
#define SSH_ERRNO_COMPRESSION_WRONG_MSG	"Trying to compress a non-compressed stream"

#define SSH_ERRNO_ZLIB_STALL_ERROR	40
#define SSH_ERRNO_ZLIB_STALL_ERROR_MSG	"Compression stalled -- no progress possible"

#define SSH_ERRNO_ZLIB_STATE_ERROR	41
#define SSH_ERRNO_ZLIB_STATE_ERROR_MSG	"Compression stream state inconsistent"

#define SSH_ERRNO_ZLIB_MORE_OUT_ERROR	42
#define SSH_ERRNO_ZLIB_MORE_OUT_ERROR_MSG	"Compression library needs more output space"

#define SSH_ERRNO_ZLIB_DEALLOC		43
#define SSH_ERRNO_ZLIB_DEALLOC_MSG	"Error deallocating compression library data structures"

#ifdef __cplusplus
extern "C" {
#endif

/*
**	ssh_errno access functions
*/

void ssh_errno_set(int error_value);	/* set ssh_errno */

int ssh_errno_get();			/* get ssh_errno */

void ssh_errno_to_str(char * msg);	/* convert errno to string */

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_ERRNO_H */

