/*
**	ssh_ident.h	-- handles saving user RSA identities
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/


#ifndef __SSH_IDENT_H
#define __SSH_IDENT_H

#define SSH_IDENT_MOD_BITS	1024		/* bits for modulus */
#define SSH_IDENT_EXP		0x10001		/* exponent */

#define SSH_PASSPHRASE_MIN_LEN	8		/* min len for a passphrase */

#define SSH_IDENTITY_HEAD	"KSSH Format 1.0"	/* header for ident */
#define SSH_IDENTITY_HEAD_LEN	30			/* max len of head */

#define SSH_IDENTITY_CHECKHEAD_LEN	4	/* header len for new format */

#ifdef __cplusplus
extern "C" {
#endif

/*
**	generate identity
*/
int ssh_identity_gen(struct ssh_struct * ssh_info, char * priv_file,
	char * pub_file, char * msg, char * passphrase, int bits);

/*
**	load identity
*/
int ssh_identity_load(struct ssh_struct * ssh_info, char * filename,	
	char * passphrase, MP_Int * public_key_modulus,
	MP_Int * public_key_exponent, MP_Int * private_key_modulus,
	MP_Int * private_key_exponent);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_IDENT_H */

