/*
**	ssh_crypt.h	-- ssh crypto stuff
**		see draft-ylonen-ssh-protocol-00.txt (15 November 1995)
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_CRYPT_H
#define __SSH_CRYPT_H

/*
**	Include Eric Young's SSLeay include files :)
*/
#include <idea.h>
#include <des.h>
#include <md5.h>
#include <rsa.h>
#include <bn.h>

/*
**	The following Encryption methds for SSHv1.5
*/
#define SSH_CIPHER_NONE		0	/* no encryption */
#define SSH_CIPHER_IDEA		1	/* IDEA in CFB mode */
#define SSH_CIPHER_DES		2	/* DES in CBC mode */
#define SSH_CIPHER_3DES		3	/* Triple-DES in CBC mode (req) */
#define SSH_CIPHER_TSS		4	/* Experimental stream cipher */
#define SSH_CIPHER_RC4		5	/* RC4 */

/*
**	Definitians to be used in encryption
*/
#define DES_IV_LEN		8	/* DES initialization vector len */

#define DES_KEY_LEN		8	/* length for a DES key */
#define MD5_DIGEST_LEN		16	/* length of an MD5 digest */

#define CRYPT_BIG_SIZE		2000	/* some big buffer size for RSA xxx */

#ifdef __cplusplus
extern "C" {
#endif

/*
**	Cipher-functions.
*/
int ssh_set_cipher(struct ssh_struct * ssh_info,	/* set a cipher method */
	uint8_t mode,		
	uint8_t * session_key);

int ssh_cipher_decode(struct ssh_struct * ssh_info,	/* decrypt packet */
	uint8_t * packet, uint8_t * out_packet);

int ssh_cipher_encode(struct ssh_struct * ssh_info,	/* encrypt packet */
	uint8_t * packet, uint8_t * out_packet);

/*
**	And here's the header for the crc32() function by Gary S. Brown
**	that appeared in Tatu Ylonen's SSH software version 1.2.20
*/
uint32_t crc32(const uint8_t * buf, unsigned int len);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_CRYPT_H */

