//----------------------------------------------------------------------
// Filename:    pkcsjnh.cpp
// Description: This file contains jonah specific routines
//                              This file is machine-independent.
//
// Notice:              Copyright 1998 IBM Inc. All rights reserved.
//----------------------------------------------------------------------
//----------------------------------------
// includes
//----------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fcntl.h>
#include <io.h>

#include "pkcsjnh.h"
#include "pkcsint.h"

#ifdef JONAHINI
#include "Jonahini.h"
#endif

//
// Set Get Token Directory                  
//

unsigned long JONAH_get_token_name(char * ptoken_name) {  
#ifdef JONAHINI

	// Get Whereabouts of Virtual Token
	IniReadString("VSC", "TokenDir", (char *) ptoken_name, sizeof(CRYPTOKI_INI), DEFAULT_TOKEN_NAME);
      return strlen((char *)ptoken_name);
#else
	return 0;
#endif
}


//
// Get initial SO pin                  
//

unsigned long JONAH_get_initial_SO_pin(char * psopin) {
#ifdef JONAHINI
	IniReadString("VSC", "InitialSOpw", (char *)psopin, TOKEN_MAX_PIN_LEN, DEFAULT_SO_PIN);
	return strlen((char *)psopin);
#else
      return 0;
#endif
}
