/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */



#include <MemSlot.h>

static MemSlot * root = NULL;
static uint32 nextSlotNo = 1;
static pki_mutex_t listMutex = PKI_MUTEX_INIT;

class initObj {
public:
  initObj(void) {
    pkiCreateMutex(&listMutex, 0);
  };
  ~initObj() {
// Need to delete all memSlots here, but this may hang if we're not careful.
// Come back later.
  };
};

static initObj init;

// The locking policy for mem slots is simple.  When translating a slot-id to
// a pointer, the invoker first locks the list, then runs the pointers to find 
// the target slot.  The target is then locked, and the list unlocked.  After
// releasing the list lock, the target slotId is re-checked, and if it is still
// valid, the slot is used, otherwise the slot lock is released and the seek
// operation fails.
//
// When a slot is deleted, the first thing that is done is that slotId is set 
// to zero, and the slot lock released.  The list lock is then acquired and the
// slot-lock is re-acquired, and the slot deleted.  This two-step process
// avoids a potential deadlock situation.
//
// The memory associated with a slot is declared ASN_SECRET, which means that
// it will be zeroed before it is returned to the heap.

MemSlot::MemSlot(uint32 * slot) : buffer(ASN_SECRET) {
  pkiLockMutex(&listMutex);
  pkiCreateMutex(&mutex, 1);
  prev = NULL;
  next = root;
  if (next) next->prev = this;
  root = this;
  slotId = nextSlotNo++;
  relatedId = 0;
  if (slot) *slot = slotId;
  pkiUnlockMutex(&listMutex);
}
  

MemSlot::~MemSlot() {
//  pkiLockMutex(&mutex);  The lock must already be held
  slotId = 0; // Slot==0 means that the slot is being removed
  pkiUnlockMutex(&mutex);
// If anyone's waiting for this slot, let them in so they'll go away
  pkiSleep(0);
  pkiLockMutex(&listMutex);
  pkiLockMutex(&mutex);
  if (prev) prev->next = next;
  if (next) next->prev = prev;
  if (this == root) root = next;
//  pkiUnlockMutex(&mutex);
  pkiDestroyMutex(&mutex);
  pkiUnlockMutex(&listMutex);
}
  
MemSlot * MemSlot::acquireSlot(uint32 slotId) {
  MemSlot * ptr;
  pkiLockMutex(&listMutex);
  ptr = root;
  while ((ptr != NULL) && (ptr->slotId != slotId)) ptr=ptr->next;
  if (ptr == NULL) {
    pkiUnlockMutex(&listMutex);
    return NULL;
  };
  pkiLockMutex(&(ptr->mutex));
  pkiUnlockMutex(&listMutex);
  if (ptr->slotId != slotId) {
    pkiUnlockMutex(&(ptr->mutex));
    return NULL;
  };
  return ptr;
}
  
MemSlot * MemSlot::acquireSlotByRelated(uint32 relId) {
  MemSlot * ptr;
  pkiLockMutex(&listMutex);
  ptr = root;
  while ((ptr != NULL) && (ptr->relatedId != relId)) ptr=ptr->next;
  if (ptr == NULL) {
    pkiUnlockMutex(&listMutex);
    return NULL;
  };
  pkiLockMutex(&(ptr->mutex));
  pkiUnlockMutex(&listMutex);
  if ((ptr->slotId == 0) || (ptr->relatedId != relId)) {
    pkiUnlockMutex(&(ptr->mutex));
    return NULL;
  };
  return ptr;
}

uint32 MemSlot::releaseSlot(void) {
  pkiUnlockMutex(&mutex);
  return 0;
}
