//
// String constants for Sections and Keys in the .ini file
//

#ifndef _SECTIONS_H_
#define _SECTIONS_H_

/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#define STRSIZE 1024

// Explicit text can only be 200 characters long
#define EXPTEXTSIZE 200

#define OID_SECTION "OIDs"
#define OID_KEYDSA "id-dsa"
#define OID_DSASHA "id-dsa-with-sha1"
#define OID_RSA "rsaEncryption"
#define OID_RSASHA "sha-1WithRSAEncryption"

// Algs sections

#define ASYM_KEY_ALG_SECTION "AsymmetricKeyAlgs"
#define ASYM_SIG_ALG_SECTION "AsymmetricSigAlgs"
#define ASYM_ENC_ALG_SECTION "AsymmetricEncAlgs"
#define SYM_ENC_ALG_SECTION  "SymmetricEncAlgs"


// General policy section and its keys

#define GEN_SECTION "General"
#define GEN_NAME "MyName"
#define GEN_NETWORK "NetworkName"
// Issuers have a number at the end (Issuer1)
#define GEN_ISSUER "Issuer"
// The URL key is of the form Issuer1URL1, and so on 
#define GEN_URL "URL"
// RAs in a CA's .ini have a number at the end (RA1)
#define GEN_RA "RA"

// Transports section
#define TRANS_SECTION "Transport"
#define TRANS_PORT  "TCPPort"
#define TRANS_PORTDEF 829
#define TRANS_RETRY "RetryInterval"
#define TRANS_RETRYDEF 45
#define TRANS_MAXERROR "MaxErrorCount"
#define TRANS_MAXERRORDEF 20


// Temporary workaround while waiting on bini file support
#define BINI_SECTION "Bini"
#define BINI_SERIAL "SerialNumber" 

// The Certificate Policy section and its keys

#define CP_SECTION "CertPolicy"
// Algorithms have a number at the end
#define CP_SIGALG "SigAlg"
#define CP_STARTTIME "StartTimeSpecifiable"
#define CP_STARTTIMEDEF 1 // Default = True 
#define CP_LIFETIMEDEF "LifeTimeDef"
#define CP_LIFETIMEDEFDEF 4380
#define CP_KEYSPEC "KeySpecifiable"
#define CP_KEYSPECDEF 1 // Default = True 
#define CP_USAGESUP "KeyUsageSupported"
#define CP_USAGESUPDEF 1 // Default = True 
#define CP_USAGEREQ "KeyUsageRequired"
#define CP_USAGEREQDEF 0 // Default = False
#define CP_POLREQ "PolicyRequired"
#define CP_POLREQDEF 0 // Default = False
#define CP_POLCRIT "PolicyCritical"
#define CP_POLCRITDEF 0 // Default = False
#define CP_EEREVOKE "EERevokeRequests"
#define CP_EEREVOKEANY "ANY"
#define CP_EEREVOKESELF "SELF"
#define CP_EEREVOKENONE "NONE"
#define CP_EEREVOKEDEF CP_EEREVOKEANY
#define CP_CRLISSUE "TimeBetweenCRLs"
#define CP_CRLISSUEDEF 730 // 1 month
#define CP_CRLDURATION "CRLDuration"
#define CP_CRLDURATIONDEF 1460 // 2 months

#define CP_POLNAME "PolicyName"
#define CP_CPS "CPS"
#define CP_USERNOTICE "UserNoticeText"
#define CP_UNOTPOL "Policy"
#define CP_UNOTORG "Org"
#define CP_UNOTNOTICE "Notice"
#endif
