
/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */
 
 /*
 * (C) COPYRIGHT International Business Machines Corp. 1996, 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */

#ifndef _LDAPDL_H
#define _LDAPDL_H

// includes

#include "cssm.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* LDAPDL constants */

static const char*
LDAPDL_NAME = "LDAP Data Storage Module";

#if defined (WIN32) || defined (OS2)
static const char*
LDAPDL_FILENAME = "LDAPDL.dll";
#endif /* WIN32 || OS2 */

#if defined (AIX4) || defined (HPUX) || defined (SOLARIS)
static const char*
LDAPDL_FILENAME = "LDAPDL.so";
#endif /* AIX4 || HPUX || SOLARIS */

static const uint32
LDAPDL_SUBSERVICEID = 0;

/* {DE693500-DB92-11d1-B1CE-002035680B00} */
static const CSSM_GUID
LDAPDL_GUID = { 0xde693500, 0xdb92, 0x11d1, { 0xb1, 0xce, 0x0, 0x20, 0x35, 0x68, 0xb, 0x0 } };

static const uint32
LDAPDL_MAJOR_VERSION = 1;

static const uint32
LDAPDL_MINOR_VERSION = 0;

/*
 * LDAPDL private errors
 */

#define LDAPDL_OPERATIONS_ERROR		(CSSM_DL_PRIVATE_ERROR + 1)
#define LDAPDL_PROTOCOL_ERROR		(CSSM_DL_PRIVATE_ERROR + 2)
#define LDAPDL_TIMELIMIT_EXCEEDED 	(CSSM_DL_PRIVATE_ERROR + 3)
#define LDAPDL_SIZELIMIT_EXCEEDED 	(CSSM_DL_PRIVATE_ERROR + 4)
#define LDAPDL_STRONG_AUTH_NOT_SUPPORTED	(CSSM_DL_PRIVATE_ERROR + 7)
#define LDAPDL_STRONG_AUTH_REQUIRED	(CSSM_DL_PRIVATE_ERROR + 8)
#define LDAPDL_PARTIAL_RESULTS		(CSSM_DL_PRIVATE_ERROR + 9)
    
#define LDAPDL_REFERRAL_NOT_FOLLOWED	(CSSM_DL_PRIVATE_ERROR + 10)
#define LDAPDL_ADMIN_LIMIT_EXCEEDED	    (CSSM_DL_PRIVATE_ERROR + 11)
#define LDAPDL_UNAVAILABLE_CRITICAL_EXTENSION  (CSSM_DL_PRIVATE_ERROR + 12)
#define LDAPDL_CONFIDENTIALITY_REQUIRED (CSSM_DL_PRIVATE_ERROR + 13)
#define LDAPDL_SASLBIND_IN_PROGRESS     (CSSM_DL_PRIVATE_ERROR + 14)  

#define LDAPDL_NO_SUCH_ATTRIBUTE		(CSSM_DL_PRIVATE_ERROR + 20)
#define LDAPDL_UNDEFINED_TYPE		    (CSSM_DL_PRIVATE_ERROR + 21)
#define LDAPDL_INAPPROPRIATE_MATCHING	(CSSM_DL_PRIVATE_ERROR + 22)
#define LDAPDL_CONSTRAINT_VIOLATION	    (CSSM_DL_PRIVATE_ERROR + 23)
#define LDAPDL_TYPE_OR_VALUE_EXISTS	    (CSSM_DL_PRIVATE_ERROR + 24)
#define LDAPDL_INVALID_SYNTAX		    (CSSM_DL_PRIVATE_ERROR + 25)

#define LDAPDL_NO_SUCH_OBJECT		    (CSSM_DL_PRIVATE_ERROR + 32)
#define LDAPDL_ALIAS_PROBLEM		    (CSSM_DL_PRIVATE_ERROR + 33)
#define LDAPDL_INVALID_DN_SYNTAX		(CSSM_DL_PRIVATE_ERROR + 34)
#define LDAPDL_IS_LEAF			        (CSSM_DL_PRIVATE_ERROR + 35)
#define LDAPDL_ALIAS_DEREF_PROBLEM	    (CSSM_DL_PRIVATE_ERROR + 36)

#define LDAPDL_INAPPROPRIATE_AUTH 	    (CSSM_DL_PRIVATE_ERROR + 48)
#define LDAPDL_INVALID_CREDENTIALS	    (CSSM_DL_PRIVATE_ERROR + 49)
#define LDAPDL_INSUFFICIENT_ACCESS	    (CSSM_DL_PRIVATE_ERROR + 50)
#define LDAPDL_BUSY                     (CSSM_DL_PRIVATE_ERROR + 51)
#define LDAPDL_UNAVAILABLE		        (CSSM_DL_PRIVATE_ERROR + 52)
#define LDAPDL_UNWILLING_TO_PERFORM	    (CSSM_DL_PRIVATE_ERROR + 53)
#define LDAPDL_LOOP_DETECT		        (CSSM_DL_PRIVATE_ERROR + 54)

#define LDAPDL_NAMING_VIOLATION		    (CSSM_DL_PRIVATE_ERROR + 64)
#define LDAPDL_OBJECT_CLASS_VIOLATION	(CSSM_DL_PRIVATE_ERROR + 65)
#define LDAPDL_NOT_ALLOWED_ON_NONLEAF	(CSSM_DL_PRIVATE_ERROR + 66)
#define LDAPDL_NOT_ALLOWED_ON_RDN 		(CSSM_DL_PRIVATE_ERROR + 67)
#define LDAPDL_ALREADY_EXISTS			(CSSM_DL_PRIVATE_ERROR + 68)
#define LDAPDL_NO_OBJECT_CLASS_MODS		(CSSM_DL_PRIVATE_ERROR + 69)
#define LDAPDL_RESULTS_TOO_LARGE		(CSSM_DL_PRIVATE_ERROR + 70)

#define LDAPDL_AFFECTS_MULTIPLE_DSAS    (CSSM_DL_PRIVATE_ERROR + 71)

#define LDAPDL_OTHER                    (CSSM_DL_PRIVATE_ERROR + 80)
#define LDAPDL_SERVER_DOWN		        (CSSM_DL_PRIVATE_ERROR + 81)
#define LDAPDL_LOCAL_ERROR				(CSSM_DL_PRIVATE_ERROR + 82)
#define LDAPDL_ENCODING_ERROR			(CSSM_DL_PRIVATE_ERROR + 83)
#define LDAPDL_DECODING_ERROR			(CSSM_DL_PRIVATE_ERROR + 84)
#define LDAPDL_TIMEOUT                  (CSSM_DL_PRIVATE_ERROR + 85)
#define LDAPDL_AUTH_UNKNOWN             (CSSM_DL_PRIVATE_ERROR + 86)
#define LDAPDL_FILTER_ERROR             (CSSM_DL_PRIVATE_ERROR + 87)
#define LDAPDL_USER_CANCELLED           (CSSM_DL_PRIVATE_ERROR + 88)
#define LDAPDL_PARAM_ERROR              (CSSM_DL_PRIVATE_ERROR + 89)
#define LDAPDL_NO_MEMORY                (CSSM_DL_PRIVATE_ERROR + 90)
#define LDAPDL_CONNECT_ERROR            (CSSM_DL_PRIVATE_ERROR + 91)
#define LDAPDL_NOT_SUPPORTED            (CSSM_DL_PRIVATE_ERROR + 92)
#define LDAPDL_CONTROL_NOT_FOUND        (CSSM_DL_PRIVATE_ERROR + 93)
#define LDAPDL_NO_RESULTS_RETURNED      (CSSM_DL_PRIVATE_ERROR + 94)
#define LDAPDL_MORE_RESULTS_TO_RETURN   (CSSM_DL_PRIVATE_ERROR + 95)

#define LDAPDL_URL_ERR_NOTLDAPDL        (CSSM_DL_PRIVATE_ERROR + 96)
#define LDAPDL_URL_ERR_NODN             (CSSM_DL_PRIVATE_ERROR + 97)
#define LDAPDL_URL_ERR_BADSCOPE         (CSSM_DL_PRIVATE_ERROR + 98)
#define LDAPDL_URL_ERR_MEM              (CSSM_DL_PRIVATE_ERROR + 99)

#define LDAPDL_CLIENT_LOOP              (CSSM_DL_PRIVATE_ERROR + 100)
#define LDAPDL_REFERRAL_LIMIT_EXCEEDED  (CSSM_DL_PRIVATE_ERROR + 101) 

#define LDAPDL_SSL_ALREADY_INITIALIZED  (CSSM_DL_PRIVATE_ERROR + 112)
#define LDAPDL_SSL_INITIALIZE_FAILED      (CSSM_DL_PRIVATE_ERROR + 113)
#define LDAPDL_SSL_CLIENT_INIT_NOT_CALLED (CSSM_DL_PRIVATE_ERROR + 114)
#define LDAPDL_SSL_PARAM_ERROR            (CSSM_DL_PRIVATE_ERROR + 115)
#define LDAPDL_SSL_HANDSHAKE_FAILED       (CSSM_DL_PRIVATE_ERROR + 116)
#define LDAPDL_SSL_GET_CIPHER_FAILED      (CSSM_DL_PRIVATE_ERROR + 117)

#define LDAPDL_NO_EXPLICIT_OWNER        (CSSM_DL_PRIVATE_ERROR + 128)
#define LDAPDL_LAST_ERROR               (CSSM_DL_PRIVATE_ERROR + 129)

#define DL_SEARCH_SCOPE "DL_SEARCH_SCOPE"
#define DL_SCOPE_BASE	"base"
#define DL_SCOPE_ONE	"one"
#define DL_SCOPE_SUB	"sub"


#define DL_SEARCH_BASE  "DL_SEARCH_BASE"
#define DL_LDAP_URL_FILTER "URL:"

#define DL_MOD_RDN "DL_MOD_RDN"


/* LDAP DL passthrough IDs */
#define DL_LDAP_MOD_ID	(1)
#define DL_LDAP_GET_OPT (2)
#define DL_LDAP_SET_OPT (3)


typedef struct SSL_Parms {
	char *keyring;     /* Name of a key ring file, which typically 
                          contains one or more certificates        */
	char *keyring_pw;  /* Password protecting the contents of the
                          key ring file                            */    
	int	 ssl_timeout;  /* Time-out value in seconds controling the 
                          frequency with which the protocol stack 
                          regenerates session keys                 */
	char *label;       /* Name associated with the client private key/
                          certificate  pair in the key ring file.  */
	char *ciphers;	   /* String identifying the encryption(s) to
	                      be used when negotiating with the server */

} LDAP_SSL_PARMS, *LDAP_SSL_PARMS_PTR;


typedef struct Bind_Parms {
		char		 *DN;  /* Distinguished Name of entry to bind as */
		int 	     SASL; /* Set to True if SASL is used */
		CSSM_DATA    credentials; /* User's password or client's X.509 
                                     certificate if SASL flag is set. */
		int 		 (*rebindproc)(); /* callback routine for getting credentials
                                         when chasing referrals.      */
} LDAP_BIND_PARMS, *LDAP_BIND_PARMS_PTR;


typedef struct LDAP_Options {
		int    option;    /* LDAP option as defined in ldap.h */
		void  *optionval; /* value of option */
} LDAP_OPTIONS, *LDAP_OPTIONS_PTR;


typedef struct { 
   CSSM_DB_RECORDTYPE   RecType;
   CSSM_DB_UNIQUE_RECORD_PTR  RecId;
   CSSM_DB_RECORD_ATTRIBUTE_DATA_PTR Attrs;
} DL_MOD_PARMS, *DL_MOD_PARMS_PTR;

#ifdef CDSA_12

static DL_MOD_PARMS DL_Mod;

#define CSSM_DL_DataModify(DLDBHandle,RecordType,UniqueRecId,Attributes,Data) \
(\
    DL_Mod.RecType = RecordType, \
    DL_Mod.RecId = UniqueRecId, \
    DL_Mod.Attrs = Attributes, \
    (CSSM_RETURN) (int) CSSM_DL_PassThrough \
	(DLDBHandle,DL_LDAP_MOD_ID,(void *)&DL_Mod) \
) 

#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _LDAPDL_H */ 
