/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef JONAH_H_
#define JONAH_H_

#ifdef __cplusplus
extern "C" {
#endif

#define IBOOL int

#include <platform.h>
#include <ObjStates.h>

/* typedef unsigned char * utf8String; */
/* The above definition is now in platform.h */

typedef struct {
  uint32 length;
  unsigned char * data;
} octetString;

typedef struct {
  uint32 year;  /* 1900..2xxx */
  uint32 month; /* 1..12 */
  uint32 day;   /* 1..31 */
  uint32 hour;  /* 0..23 */
  uint32 min;   /* 0..59 */
  uint32 sec;   /* 0..59 */
  uint32 msec;  /* 0..999 */
} utcDateTime;


typedef uint32 keyUsage_t;
#define usageDigitalSignature 1
#define usageNonRepudiation   2
#define usageKeyEncipherment  4
#define usageDataEncipherment 8
#define usageKeyAgreement    16
#define usageKeyCertSign     32
#define usageCRLSign         64
#define usageEncipherOnly   128
#define usageDecipherOnly   256



EXPORTFN(uint32,
         JNH_release_utf8String,
         (utf8String s));
/* 
 * Release the memory associated with a UTF-8 string. 
 */

EXPORTFN(uint32,
         JNH_release_octetString,
         (octetString s));
/* 
 * Release the memory associated with an octet-string. 
 */

EXPORTFN(uint32,
         JNH_release_octetStrings,
         (uint32 numStrings,
          octetString * s));
/*
 * Release the memory associated with an array of octet-strings (e.g. the
 * array returned by JNH_inquire_certreq_policies)
 */

EXPORTFN(uint32,
         JNH_release_utf8Strings,
         (uint32 numStrings,
          utf8String * s));
/*
 * Release the memory associated with an array of utf8Strings (e.g. the
 * bases array returned by JNH_inquire_certreq_nameConstraints_permittedSubtrees
  */

EXPORTFN(uint32,
         JNH_release_ints,
         (uint32 numInts,
          uint32 * s));
/*
 * Release the memory associated with an array of uint32 values (e.g. the
 * notice array returned by JNH_inquire_certreq_policyQualifiers_userNotice
 */

EXPORTFN(uint32,
         JNH_reserve_object,
         (uint32 objId));
/* 
 * Reserve an object for subsequent inquire/set access.
 * Objects must be reserved before and inquire/set routines
 * are invoked on them.
 */
 
#ifdef OBSOLETE
EXPORTFN(uint32,
         JNH_synch_object,
         (uint32 objId));
#endif
EXPORTFN(uint32,
         JNH_save_object,
         (uint32 objId));
/* Write the specified object to backing-store and release it */

EXPORTFN(uint32,
         JNH_release_object,
         (uint32 objId));
/* Release an object without saving changes */

EXPORTFN(uint32,
         JNH_provide_password,
         (const utf8String password,
          uint32 objId,
          uint32 pwdId));
/*
 * Provide a password to an object.
 * Occasionally, an object may require more than
 * one password, in which case pwdId is used to
 * identify which password is being provided.
 */

EXPORTFN(uint32,
         JNH_login_pwd,
         (const utf8String user,
          const utf8String pwd,
          const utf8String device,
          uint32 keyVersion,
          const utf8String algorithm,
          uint32 keySelector,
          IBOOL objectController,
          utf8String * fullname,
          uint32 * keyId));
/* Unlock the specified user's key with a password. */

EXPORTFN(uint32,
         JNH_server_login_pwd,
         (const utf8String pwd));
/* Unlock the server's credentials by directly supplying a PIN. */

EXPORTFN(uint32,
         JNH_server_login_key,
         (uint32 storageKeyId));
/* Unlock the server's credentials indirectly via a storage key. */

EXPORTFN(uint32,
         JNH_login_key,
         (const utf8String user,
          uint32 storageKeyId,
          const utf8String device,
          uint32 keyVersion,
          const utf8String algorithm,
          uint32 keySelector,
          IBOOL objectController,
          utf8String * fullname,
          uint32 * keyId));

EXPORTFN(uint32,
         JNH_store_key_pwd,
         (uint32 keyId,
          const utf8String pwd,
          const utf8String device));

EXPORTFN(uint32,
         JNH_store_key,
         (uint32 keyId,
          uint32 storageKeyId,
          const utf8String device));

EXPORTFN(uint32,
         JNH_export_credential,
         (uint32 reqId, 
          const utf8String password, 
          const utf8String device));
/* device is one of:
 *
 *   "VSC[:fileName]",
 *   "TOK[:readerName]"
 *   "PKCS12:fileName"
 *
 * where VSC indicates the virtual smart-card, TOK indicates 
 * a real smart-card, and P12 indicates a PKCS#12 file.
 */

EXPORTFN(uint32,
         JNH_logout,
         (uint32 keyId));

EXPORTFN(uint32,
         JNH_audit,
         (uint32 reqId,
          const utf8String text));

EXPORTFN(uint32,
         JNH_register_user,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_authorize_registration,
         (uint32 reqId,
          uint32 keyId));

EXPORTFN(uint32,
         JNH_reject_registration,
         (uint32 reqId,
          utf8String message));

EXPORTFN(uint32,
         JNH_validate_registration,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_preregister_user,
         (const utf8String preregistrationRecord,
          const utf8String passwd,
          uint32 * reqId));

EXPORTFN(uint32,
         JNH_RA_preregister_user,
         (const utf8String CAname,
          const utf8String username,
          uint32 expirationSeconds,
          const utf8String passwd,
          utf8String * preregistrationRecord));

EXPORTFN(uint32,
         JNH_create_certreq,
         (uint32 * reqId));

EXPORTFN(uint32,
         JNH_create_certificate,
         (uint32 reqId,
          uint32 CAkeyId));

EXPORTFN(uint32,
         JNH_publish_certificate,
         (uint32 reqId));

EXPORTFN(uint32, 
         JNH_create_revreq,
         (uint32 reqID));

EXPORTFN(uint32,
         JNH_request_revocation,
         (uint32 reqID));

EXPORTFN(uint32, 
         JNH_cancel_revreq, 
         (uint32 reqID));

EXPORTFN(uint32,
         JNH_authorize_revocation,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_reject_revocation,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_revoke_certificate,
         (uint32 reqId));

EXPORTFN(uint32, 
         JNH_request_CRL, 
         (utf8String issuer));

EXPORTFN(uint32,
         JNH_create_new_revreq, 
         (uint32 *reqId));

EXPORTFN(uint32,
         JNH_createCRL,
         (uint32 * crlId));

EXPORTFN(uint32,
         JNH_publish_CRL,
         (uint32 crlId));

EXPORTFN(uint32,
         JNH_inquire_certreq_status,
         (uint32 reqId, 
          uint32 * status));

EXPORTFN(uint32,
         JNH_inquire_certreq_subjectkey_present,
         (uint32 reqId,
          IBOOL * keyPresent));

EXPORTFN(uint32,
         JNH_inquire_certreq_subjectkey_algorithm,
         (uint32 reqId,
          octetString * algorithm));

EXPORTFN(uint32,
         JNH_inquire_certreq_subjectkey,
         (uint32 reqId,
          octetString * key));

EXPORTFN(uint32,
         JNH_inquire_certreq_serialnumber,
         (uint32 reqId,
          octetString * serialNumber));

EXPORTFN(uint32,
         JNH_inquire_certreq_subject,
         (uint32 reqId,
          utf8String * subject));

EXPORTFN(uint32,
         JNH_inquire_certreq_DNSsubject,
         (uint32 reqId,
          utf8String * subject));

EXPORTFN(uint32,
         JNH_inquire_certreq_822subject,
         (uint32 reqId,
          utf8String * subject));

EXPORTFN(uint32,
         JNH_inquire_certreq_IPAddrsubject,
         (uint32 reqId,
          octetString * subject));

EXPORTFN(uint32,
         JNH_inquire_certreq_issuer,
         (uint32 reqId,
          utf8String * issuer));

EXPORTFN(uint32,
         JNH_inquire_certreq_startdate,
         (uint32 reqId,
          utcDateTime * startDate));
                
EXPORTFN(uint32,
         JNH_inquire_certreq_enddate,
         (uint32 reqId,
          utcDateTime * endDate));

EXPORTFN(uint32,
         JNH_inquire_certreq_policies,
         (uint32 reqId,
          uint32 * numberPolicies,
          octetString ** policies));

EXPORTFN(uint32,
         JNH_inquire_certreq_authorityKeyId,
         (uint32 reqId,
          octetString * keyId,
          utf8String * authorityName,
          octetString * serialNumber));

EXPORTFN(uint32,
         JNH_inquire_certreq_subjectKeyId,
         (uint32 reqId,
          octetString * subjectKeyId));

EXPORTFN(uint32,
         JNH_inquire_certreq_keyUsage,
         (uint32 reqId,
          keyUsage_t * usages));

EXPORTFN(uint32,
         JNH_inquire_certreq_privateKeyUsagePeriod,
         (uint32 reqId,
          utcDateTime * notBefore,
          utcDateTime * notAfter));

EXPORTFN(uint32,
         JNH_inquire_certreq_policyQualifiers_CPS,
         (uint32 reqId,
          const octetString policy,
          octetString * policyQualifierId,
          utf8String * CPS_URI));

EXPORTFN(uint32,
         JNH_inquire_certreq_policyQualifiers_userNotice,
         (uint32 reqId,
          const octetString policy,
          octetString * policyQualifierId,
          utf8String * explicitText,
          utf8String * organization,
          uint32 * numberNotices,
          uint32 ** notices));

EXPORTFN(uint32,
         JNH_inquire_certreq_policyMappings,
         (uint32 reqId,
          uint32 * numberMappings,
          octetString ** issuerDomainPolicies,
          octetString ** subjectDomainPolicies));

EXPORTFN(uint32,
         JNH_inquire_certreq_basicConstraints,
         (uint32 reqId,
          IBOOL * isCaCert,
          uint32 * maxPathLen));

EXPORTFN(uint32,
         JNH_inquire_certreq_nameConstraints_permittedSubtrees,
         (uint32 reqId,
          uint32 * numberSubtrees,
          utf8String ** bases,
          uint32 ** maxLengths,
          uint32 ** minLenths));

EXPORTFN(uint32,
         JNH_inquire_certreq_nameConstraints_excludedSubtrees,
         (uint32 reqId,
          uint32 * numberSubtrees,
          utf8String ** bases,
          uint32 ** maxLengths,
          uint32 ** minLenths));

EXPORTFN(uint32,
         JNH_inquire_certreq_policyConstraints,
         (uint32 reqId,
          uint32 * numberConstraints,
          octetString ** policies,
          IBOOL ** requireExplicitPolicy,
          IBOOL ** inhibitMapping));
                                   
EXPORTFN(uint32,
         JNH_inquire_certreq_xKeyUsages,
         (uint32 reqId,
          uint32 * numberUsages,
          octetString ** usages));

EXPORTFN(uint32,
         JNH_inquire_certreq_extensions,
         (uint32 reqId,
          uint32 * numberExtensions,
          octetString ** extensions,
          IBOOL ** critical,
          octetString ** value));

EXPORTFN(uint32,
         JNH_set_certreq_subjectKey,
         (uint32 reqId,
          uint32 keyId));

EXPORTFN(uint32,
         JNH_set_certreq_subject,
         (uint32 reqId,
          const utf8String subject));

EXPORTFN(uint32,
         JNH_set_certreq_822subject,
         (uint32 reqId,
          const utf8String subject));

EXPORTFN(uint32,
         JNH_set_certreq_DNSsubject,
         (uint32 reqId,
          const utf8String subject));

EXPORTFN(uint32,
         JNH_set_certreq_IPAddrsubject,
         (uint32 reqId,
          const octetString subject));

EXPORTFN(uint32,
         JNH_set_certreq_issuer,
         (uint32 reqId,
          const utf8String issuer));

EXPORTFN(uint32,
         JNH_set_certreq_startDate,
         (uint32 reqId,
          utcDateTime notBefore));

EXPORTFN(uint32,
         JNH_set_certreq_endDate,
         (uint32 reqId,
          utcDateTime notAfter));

EXPORTFN(uint32,
         JNH_add_certreq_policy,
         (uint32 reqId,
          const octetString policy));

EXPORTFN(uint32,
         JNH_remove_certreq_policy,
         (uint32 reqId,
          const octetString policy));

EXPORTFN(uint32,
         JNH_clear_certreq_policy,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_set_certreq_authorityKeyId,
         (uint32 reqId,
          const octetString keyId,
          const utf8String authorityName,
          const octetString serialNumber));

EXPORTFN(uint32,
         JNH_set_certreq_keyUsage,
         (uint32 reqId,
          keyUsage_t keyUsage));

EXPORTFN(uint32,
         JNH_set_certreq_privateKeyUsagePeriod,
         (uint32 reqId,
          utcDateTime notBefore,
          utcDateTime notAfter));

EXPORTFN(uint32,
         JNH_add_certreq_policyQualifiers_CPS,
         (uint32 reqId,
          const octetString policyId,
          const utf8String CPS_URI));

EXPORTFN(uint32,
         JNH_remove_certreq_policyQualifiers_CPS,
         (uint32 reqId,
          const octetString policyId));

EXPORTFN(uint32,
         JNH_clear_certreq_policyQualifiers_CPS,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_add_certreq_policyQualifiers_userNotice,
         (uint32 reqId,
          const octetString policyId,
          const utf8String explicitText,
          const utf8String organization,
          uint32 numberNotices,
          uint32 notices[]));

EXPORTFN(uint32,
         JNH_remove_certreq_policyQualifiers_userNotice,
         (uint32 reqId,
          const octetString policyId));

EXPORTFN(uint32,
         JNH_clear_certreq_policyQualifiers_userNotice,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_add_certreq_policyMapping,
         (uint32 reqId,
          const octetString issuerDomainPolicy,
          const octetString subjectDomainPolicy));

EXPORTFN(uint32,
         JNH_remove_certreq_policyMapping,
         (uint32 reqId,
          const octetString issuerDomainPolicy,
          const octetString subjectDomainPolicy));

EXPORTFN(uint32,
         JNH_clear_certreq_policyMapping,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_set_certreq_basicConstraints,
         (uint32 reqId,
          IBOOL isCaCert,
          uint32 maxPathLen));

EXPORTFN(uint32,
         JNH_set_certreq_nameConstraints_permittedSubtrees,
         (uint32 reqId,
          const utf8String base,
          uint32 maxLength,
          uint32 minLength));

EXPORTFN(uint32,
         JNH_remove_certreq_nameConstraints_permittedSubtrees,
         (uint32 reqId,
          const utf8String base,
          uint32 maxLength,
          uint32 minLength));

EXPORTFN(uint32,
         JNH_clear_certreq_nameConstraints_permittedSubtrees,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_set_certreq_nameConstraints_excludedSubtrees,
         (uint32 reqId,
          const utf8String base,
          uint32 maxLength,
          uint32 minLength));

EXPORTFN(uint32,
         JNH_remove_certreq_nameConstraints_excludedSubtrees,
         (uint32 reqId,
          const utf8String base,
          uint32 maxLength,
          uint32 minLength));

EXPORTFN(uint32,
         JNH_clear_certreq_nameConstraints_excludedSubtrees,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_add_certreq_policyConstraints,
         (uint32 reqId,
          const octetString policyId,
          IBOOL requireExplicitPolicy,
          IBOOL inhibitMapping));

EXPORTFN(uint32,
         JNH_remove_certreq_policyConstraints,
         (uint32 reqId,
          const octetString policyId));

EXPORTFN(uint32,
         JNH_clear_certreq_policyConstraints,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_add_certreq_xKeyUsages,
         (uint32 reqId,
          const octetString usage));

EXPORTFN(uint32,
         JNH_remove_certreq_xKeyUsages,
         (uint32 reqId,
          const octetString usage));

EXPORTFN(uint32,
         JNH_clear_certreq_xKeyUsages,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_add_certreq_extensions,
         (uint32 reqId,
          const octetString extId,
          IBOOL critical,
          const octetString value));

EXPORTFN(uint32,
         JNH_remove_certreq_extensions,
         (uint32 reqId,
          const octetString extId));

EXPORTFN(uint32,
         JNH_clear_certreq_extensions,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_set_certreq_privkey_import,
         (uint32 reqId,
          const utf8String filename,
          const utf8String password));

EXPORTFN(uint32,
         JNH_set_certreq_privkey_EE,
         (uint32 reqId,
          const utf8String algorithm,
          uint32 keylength));

EXPORTFN(uint32,
         JNH_set_certreq_privkey_CA,
         (uint32));

EXPORTFN(uint32,
         JNH_retrieve_cert,
         (const octetString serialNumber,
          uint32 * reqId));

EXPORTFN(uint32,
         JNH_list_certs_by_subject,
         (const utf8String subject,
          IBOOL CAcert,
          octetString ** snums));

EXPORTFN(uint32,
         JNH_list_certs_by_subject_date,
         (const utf8String subject,
          IBOOL CAcert,
          utcDateTime notBefore,
          utcDateTime notAfter,
          octetString ** snums));

EXPORTFN(uint32,
         JNH_list_objects,
         (void));

EXPORTFN(uint32,
         JNH_list_surrogates,
         (void));

EXPORTFN(uint32,
         JNH_delete_object,
         (uint32 reqId));

EXPORTFN(uint32,
         JNH_get_error,
         (uint32 errorCode,
          utf8String * errorText));

EXPORTFN(uint32,
         JNH_validate_pwd,
         (uint32 pwdType,
          const utf8String pwd));

#define pwdType_RA 1
#define pwdType_CA 2
#define pwdType_user 10
#define pwdType_RA_admin 11
#define pwdType_CA_admin 12
                
EXPORTFN(uint32,
         JNH_OID_to_name,
         (const octetString objectId,
          utf8String * name));

EXPORTFN(uint32,
         JNH_name_to_OID,
         (const utf8String name,
          octetString * objectId));

EXPORTFN(uint32,
         JNH_INI_readString,
         (const utf8String section,
          const utf8String key,
          utf8String * value,
          const utf8String defaultValue));

EXPORTFN(uint32,
         JNH_INI_writeString,
         (const utf8String section,
          const utf8String key,
          const utf8String value));

EXPORTFN(uint32,
         JNH_INI_readInteger,
         (const utf8String section,
          const utf8String key,
          int * value,
          int defaultValue));

EXPORTFN(uint32,
         JNH_INI_writeInteger,
         (const utf8String section,
          const utf8String key,
          int value));

EXPORTFN(uint32,
         JNH_INI_readIBOOLean,
         (const utf8String section,
          const utf8String key,
          IBOOL * value,
          IBOOL defaultValue));

EXPORTFN(uint32,
         JNH_INI_writeIBOOLean,
         (const utf8String section,
          const utf8String key,
          IBOOL value));

EXPORTFN(uint32,
         JNH_start_server,
         (int serverType));
#define svrType_EE 0
#define svrType_RA 1
#define svrType_CA 2

/* JNH_register_callback is obsolete.  Use JNH_register_callbacks instead */
EXPORTFN(uint32,
         JNH_register_callback,
         (void (* JNH_Notify)(uint32 eventId, 
                              uint32 eventStatus)));

#ifndef NEW_NOTIFY_SIGNATURE
EXPORTFN(uint32,
         JNH_register_callbacks,
         (void (* JNH_Notify)(uint32 eventId, 
                              uint32 eventStatus),
          void (* JNH_Display)(uint32 displayType,
                               const utf8String message)));

#else
EXPORTFN(uint32,
         JNH_register_callbacks,
         (void (* JNH_Notify)(uint32 eventId, 
                              uint32 eventStatus,
                              utf8String * suppInfo),
          void (* JNH_Display)(uint32 displayType,
                               const utf8String message)));
#endif
#define DISPLAY_STATUSBAR     1
#define DISPLAY_LOGERROR     11
#define DISPLAY_LOGINFO      12
#define DISPLAY_LOGDEBUG     13
#define DISPLAY_URGENTERROR  21
#define DISPLAY_URGENTINFO   22
#define DISPLAY_URGENTDEBUG  23

EXPORTFN(uint32,
         JNH_check_configuration,
         (uint32 * state));
#define svrSt_Inactive     0
#define svrSt_Freestanding 1
#define svrSt_Bootstrap    2
#define svrSt_Running     10


EXPORTFN(uint32,
         JNH_create_keypair,
         (const utf8String ownerName,
          const utf8String algorithm,
          uint32 size,
          keyUsage_t usages,
          uint32 * keyId));

EXPORTFN(uint32,
        JNH_get_algorithms,
        (uint32 algType,
         uint32 * numberAlgorithm,
         utf8String ** names));

#define algType_AsymmetricKey          1
#define algType_AsymmetricSign         2
#define algType_AsymmetricEncrypt      3
#define algType_Symmetric              4


EXPORTFN(uint32,
         JNH_get_default_server_name,
         (utf8String * name));

/*
EXPORTFN(uint32,
         JNH_get_default_admin_name,
         (utf8String * name));

EXPORTFN(uint32,
         JNH_get_default_server_keystore,
         (utf8String * name));

EXPORTFN(uint32,
        JNH_get_default_admin_keystore,
        (utf8String * name));
*/

EXPORTFN(uint32,
         JNH_CA_initialize,
         (uint32 keyId,
          uint32 * certId,
          uint32 * crlId));

EXPORTFN(uint32,
         JNH_create_keyRecord,
         (uint32 keyId,
          octetString * keyRecord,
          utf8String * fingerprint));

EXPORTFN(uint32,
         JNH_CA_update_keypair,
         (uint32 oldKeyId,
          uint32 * newKeyId,
          uint32 * newWithNew,
          uint32 * newWithOld,
          uint32 * oldWithNew));

EXPORTFN(uint32,
         JNH_CA_enroll_RA,
         (uint32 CAkeyId,
          const octetString raKeyRecord,
          const utf8String raFingerprint));

EXPORTFN(uint32,
         JNH_CA_unenroll_RA,
         (const utf8String raName));

EXPORTFN(uint32,
         JNH_CA_list_RAs,
         (uint32 * numberRAs,
          utf8String ** raNames));

EXPORTFN(uint32,
         JNH_dismiss_condition,
         (uint32 reqId));
/* Dismiss a pending condition for the specified object.                             */

EXPORTFN(uint32,
         JNH_get_condition_info,
         (uint32 reqId,
          uint32 * state,
          uint32 * error,
          IBOOL * recoverable,
          IBOOL * deletable,
          utf8String * operation,
          utf8String * condition));
/* Returns information about any pending condition relating to the object.  <state>  */
/* constains the current state of the object, while <error>  is a Jonah error code,  */
/* or zero if no pending condition exists.  For non-zero values of <error>,          */
/* <dismissable> will be true if the condition may be dismissed, and <deletable>     */
/* will  be true if the object may be deleted.  At least one of these flags will be  */
/* true if <error> is non-zero.  <operation> will contain text that describes the    */
/* operation that encountered the condition, <condition> will contain text that      */
/* describes the condition itself.  Either string may be omitted, but for non-zero   */
/* <error> values, at least one will be present.                                     */




EXPORTFN(uint32,
         JNH_inquire_revreq_certserialnumber,
         (uint32 req_id,
          octetString * serialNumber));

EXPORTFN(uint32,
         JNH_set_revreq_certserialnumber,
         (uint32 req_id,
          octetString * serialNumber));

EXPORTFN(uint32,
         JNH_inquire_revreq_revocationDate,
         (uint32 req_id,
          utcDateTime * revocationDate));

EXPORTFN(uint32,
         JNH_set_revreq_revocationDate,
         (uint32 req_id,
          const utcDateTime revocationDate));
          
EXPORTFN(uint32,
         JNH_inquire_revreq_reason,
         (uint32 req_id,
          int * reason));

EXPORTFN(uint32,
         JNH_set_revreq_reason,
         (uint32 req_id,
          int * reason));
#define REV_REASON_UNSPECIFIED 0
#define REV_REASON_KEY_COMPROMISE 1
#define REV_REASON_CA_COMPROMISE 2
#define REV_REASON_AFFILIATION_CHANGED 3
#define REV_REASON_SUPERSEDED 4
#define REV_REASON_CESSATION_OF_OPERATION 5
#define REV_REASON_CERTIFICATE_HOLD 6
#define REV_REASON_REMOVE_FROM_CRL 8

EXPORTFN(uint32,
         JNH_inquire_revreq_hold_instruction_code,
         (uint32 req_id,
          octetString * code));

EXPORTFN(uint32,
         JNH_set_revreq_hold_instruction_code,
         (uint32 req_id,
          const octetString code));


EXPORTFN(uint32,
         JNH_inquire_revreq_invalidityDate,
         (uint32 req_id,
          utcDateTime * invalidityDate));

EXPORTFN(uint32,
         JNH_set_revreq_invalidityDate,
         (uint32 req_id,
          utcDateTime invalidityDate));

EXPORTFN(uint32,
         JNH_inquire_revreq_certIssuer,
         (uint32 req_id,
          utf8String * certIssuer));

EXPORTFN(uint32,
         JNH_set_revreq_certIssuer,
         (uint32 req_id,
          const utf8String certIssuer));




#ifdef __cplusplus
}
#endif

#endif
