/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef ASN_CHARDEFS_H_
#define ASN_CHARDEFS_H_


#define IA5_CAP_A               (unsigned char)0x41
#define IA5_CAP_B               (unsigned char)0x42
#define IA5_CAP_C               (unsigned char)0x43
#define IA5_CAP_D               (unsigned char)0x44
#define IA5_CAP_E               (unsigned char)0x45
#define IA5_CAP_F               (unsigned char)0x46
#define IA5_CAP_G               (unsigned char)0x47
#define IA5_CAP_H               (unsigned char)0x48
#define IA5_CAP_I               (unsigned char)0x49
#define IA5_CAP_J               (unsigned char)0x4a
#define IA5_CAP_K               (unsigned char)0x4b
#define IA5_CAP_L               (unsigned char)0x4c
#define IA5_CAP_M               (unsigned char)0x4d
#define IA5_CAP_N               (unsigned char)0x4e
#define IA5_CAP_O               (unsigned char)0x4f
#define IA5_CAP_P               (unsigned char)0x50
#define IA5_CAP_Q               (unsigned char)0x51
#define IA5_CAP_R               (unsigned char)0x52
#define IA5_CAP_S               (unsigned char)0x53
#define IA5_CAP_T               (unsigned char)0x54
#define IA5_CAP_U               (unsigned char)0x55
#define IA5_CAP_V               (unsigned char)0x56
#define IA5_CAP_W               (unsigned char)0x57
#define IA5_CAP_X               (unsigned char)0x58
#define IA5_CAP_Y               (unsigned char)0x59
#define IA5_CAP_Z               (unsigned char)0x5a

#define IA5_LOWER_A             (unsigned char)0x61
#define IA5_LOWER_B             (unsigned char)0x62
#define IA5_LOWER_C             (unsigned char)0x63
#define IA5_LOWER_D             (unsigned char)0x64
#define IA5_LOWER_E             (unsigned char)0x65
#define IA5_LOWER_F             (unsigned char)0x66
#define IA5_LOWER_G             (unsigned char)0x67
#define IA5_LOWER_H             (unsigned char)0x68
#define IA5_LOWER_I             (unsigned char)0x69
#define IA5_LOWER_J             (unsigned char)0x6a
#define IA5_LOWER_K             (unsigned char)0x6b
#define IA5_LOWER_L             (unsigned char)0x6c
#define IA5_LOWER_M             (unsigned char)0x6d
#define IA5_LOWER_N             (unsigned char)0x6e
#define IA5_LOWER_O             (unsigned char)0x6f
#define IA5_LOWER_P             (unsigned char)0x70
#define IA5_LOWER_Q             (unsigned char)0x71
#define IA5_LOWER_R             (unsigned char)0x72
#define IA5_LOWER_S             (unsigned char)0x73
#define IA5_LOWER_T             (unsigned char)0x74
#define IA5_LOWER_U             (unsigned char)0x75
#define IA5_LOWER_V             (unsigned char)0x76
#define IA5_LOWER_W             (unsigned char)0x77
#define IA5_LOWER_X             (unsigned char)0x78
#define IA5_LOWER_Y             (unsigned char)0x79
#define IA5_LOWER_Z             (unsigned char)0x7a

#define IA5_0                   (unsigned char)0x30
#define IA5_1                   (unsigned char)0x31
#define IA5_2                   (unsigned char)0x32
#define IA5_3                   (unsigned char)0x33
#define IA5_4                   (unsigned char)0x34
#define IA5_5                   (unsigned char)0x35
#define IA5_6                   (unsigned char)0x36
#define IA5_7                   (unsigned char)0x37
#define IA5_8                   (unsigned char)0x38
#define IA5_9                   (unsigned char)0x39

#define IA5_PLUS                (unsigned char)0x2b
#define IA5_MINUS               (unsigned char)0x2d

#define IA5_COMMA               (unsigned char)0x2c
#define IA5_PERIOD              (unsigned char)0x2e

#define IA5_BS                  (unsigned char)0x08
#define IA5_LF                  (unsigned char)0x0a
#define IA5_FF                  (unsigned char)0x0c
#define IA5_CR                  (unsigned char)0x0d
#define IA5_SUB                 (unsigned char)0x1a
#define IA5_HASH                (unsigned char)0x23
#define IA5_DOLLAR              (unsigned char)0x24
#define IA5_SP                  (unsigned char)0x20
#define IA5_TILDE               (unsigned char)0x7e
#define IA5_DOWNBANG            (unsigned char)0xa1
#define IA5_POUND               (unsigned char)0xa3
#define IA5_CURRENCY            (unsigned char)0xa4
#define IA5_YEN                 (unsigned char)0xa5
#define IA5_A_BAR               (unsigned char)0xaa
#define IA5_PARA                (unsigned char)0xb6
#define IA5_SECTION             (unsigned char)0xa7
#define IA5_LEFTCHEVRON         (unsigned char)0xab
#define IA5_RIGHTCHEVRON        (unsigned char)0xbb
#define IA5_DEGREE              (unsigned char)0xb0
#define IA5_SUPER3              (unsigned char)0xb3
#define IA5_MU                  (unsigned char)0xb5
#define IA5_CENTERDOT           (unsigned char)0xb7
#define IA5_O_BAR               (unsigned char)0xba
#define IA5_QUARTER             (unsigned char)0xbc
#define IA5_DOWNQMARK           (unsigned char)0xbf
#define IA5_CAP_A_GRAVE         (unsigned char)0xc0
#define IA5_CAP_A_ACUTE         (unsigned char)0xc1
#define IA5_CAP_A_CIRCUMFLEX    (unsigned char)0xc2
#define IA5_CAP_A_TILDE         (unsigned char)0xc3
#define IA5_CAP_A_DIAERESIS     (unsigned char)0xc4
#define IA5_CAP_A_CIRCLE        (unsigned char)0xc5
#define IA5_CAP_AE              (unsigned char)0xc6
#define IA5_CAP_C_CEDILLA       (unsigned char)0xc7
#define IA5_CAP_E_GRAVE         (unsigned char)0xc8
#define IA5_CAP_E_ACUTE         (unsigned char)0xc9
#define IA5_CAP_E_CIRCUMFLEX    (unsigned char)0xca
#define IA5_CAP_E_DIAERESIS     (unsigned char)0xcb
#define IA5_CAP_I_GRAVE         (unsigned char)0xcc
#define IA5_CAP_I_ACUTE         (unsigned char)0xcd
#define IA5_CAP_I_CIRCUMFLEX    (unsigned char)0xce
#define IA5_CAP_I_DIAERESIS     (unsigned char)0xcf

#define IA5_CAP_D_BAR           (unsigned char)0xd0
#define IA5_CAP_N_TILDE         (unsigned char)0xd1
#define IA5_CAP_O_GRAVE         (unsigned char)0xd2
#define IA5_CAP_O_ACUTE         (unsigned char)0xd3
#define IA5_CAP_O_CIRCUMFLEX    (unsigned char)0xd4
#define IA5_CAP_O_TILDE         (unsigned char)0xd5
#define IA5_CAP_O_DIAERESIS     (unsigned char)0xd6
#define IA5_CROSS               (unsigned char)0xd7
#define IA5_CAP_O_BAR           (unsigned char)0xd8
#define IA5_CAP_U_GRAVE         (unsigned char)0xd9
#define IA5_CAP_U_ACUTE         (unsigned char)0xda
#define IA5_CAP_U_CIRCUMFLEX    (unsigned char)0xdb
#define IA5_CAP_U_DIAERESIS     (unsigned char)0xdc
#define IA5_CAP_Y_ACUTE         (unsigned char)0xdd
#define IA5_CAP_P_BAR           (unsigned char)0xde
#define IA5_BETA                (unsigned char)0xdf

#define IA5_LOWER_A_GRAVE       (unsigned char)0xe0
#define IA5_LOWER_A_ACUTE       (unsigned char)0xe1
#define IA5_LOWER_A_CIRCUMFLEX  (unsigned char)0xe2
#define IA5_LOWER_A_TILDE       (unsigned char)0xe3
#define IA5_LOWER_A_DIAERESIS   (unsigned char)0xe4
#define IA5_LOWER_A_CIRCLE      (unsigned char)0xe5
#define IA5_LOWER_AE            (unsigned char)0xe6
#define IA5_LOWER_C_CEDILLA     (unsigned char)0xe7
#define IA5_LOWER_E_GRAVE       (unsigned char)0xe8
#define IA5_LOWER_E_ACUTE       (unsigned char)0xe9
#define IA5_LOWER_E_CIRCUMFLEX  (unsigned char)0xea
#define IA5_LOWER_E_DIAERESIS   (unsigned char)0xeb
#define IA5_LOWER_I_GRAVE       (unsigned char)0xec
#define IA5_LOWER_I_ACUTE       (unsigned char)0xed
#define IA5_LOWER_I_CIRCUMFLEX  (unsigned char)0xee
#define IA5_LOWER_I_DIAERESIS   (unsigned char)0xef

#define IA5_LOWER_D_BAR         (unsigned char)0xf0
#define IA5_LOWER_N_TILDE       (unsigned char)0xf1
#define IA5_LOWER_O_GRAVE       (unsigned char)0xf2
#define IA5_LOWER_O_ACUTE       (unsigned char)0xf3
#define IA5_LOWER_O_CIRCUMFLEX  (unsigned char)0xf4
#define IA5_LOWER_O_TILDE       (unsigned char)0xf5
#define IA5_LOWER_O_DIAERESIS   (unsigned char)0xf6
#define IA5_DIVISION            (unsigned char)0xf7
#define IA5_LOWER_O_BAR         (unsigned char)0xf8
#define IA5_LOWER_U_GRAVE       (unsigned char)0xf9
#define IA5_LOWER_U_ACUTE       (unsigned char)0xfa
#define IA5_LOWER_U_CIRCUMFLEX  (unsigned char)0xfb
#define IA5_LOWER_U_DIAERESIS   (unsigned char)0xfc
#define IA5_LOWER_Y_ACUTE       (unsigned char)0xfd
#define IA5_LOWER_P_BAR         (unsigned char)0xfe
#define IA5_LOWER_Y_DIAERESIS   (unsigned char)0xff



#define T61_SP                  (unsigned char)0x20

#define T61_DOWNBANG            (unsigned char)0xa1
#define T61_POUND               (unsigned char)0xa3
#define T61_DOLLAR              (unsigned char)0xa4
#define T61_YEN                 (unsigned char)0xa5
#define T61_HASH                (unsigned char)0xa6
#define T61_SECTION             (unsigned char)0xa7
#define T61_CURRENCY            (unsigned char)0xa8
#define T61_LEFTCHEVRON         (unsigned char)0xab

#define T61_DEGREE              (unsigned char)0xb0
#define T61_SUPER3              (unsigned char)0xb3
#define T61_CROSS               (unsigned char)0xb4
#define T61_MU                  (unsigned char)0xb5
#define T61_PARA                (unsigned char)0xb6
#define T61_CENTERDOT           (unsigned char)0xb7
#define T61_DIVISION            (unsigned char)0xb8
#define T61_RIGHTCHEVRON        (unsigned char)0xbb
#define T61_DOWNQMARK           (unsigned char)0xbf

#define T61_ACCENT_GRAVE        (unsigned char)0xc1
#define T61_ACCENT_ACUTE        (unsigned char)0xc2
#define T61_ACCENT_CIRCUMFLEX   (unsigned char)0xc3
#define T61_ACCENT_TILDE        (unsigned char)0xc4
#define T61_ACCENT_MACRON       (unsigned char)0xc5
#define T61_ACCENT_BREVE        (unsigned char)0xc6
#define T61_ACCENT_DOT          (unsigned char)0xc7
#define T61_ACCENT_DIAERESIS    (unsigned char)0xc8
#define T61_ACCENT_OLDUMLAUT    (unsigned char)0xc9
#define T61_ACCENT_CIRCLE       (unsigned char)0xca
#define T61_ACCENT_CEDILLA      (unsigned char)0xcb
#define T61_NONSPACE_UNDERLINE  (unsigned char)0xcc
#define T61_ACCENT_DOUBLE_ACUTE (unsigned char)0xcd
#define T61_ACCENT_OGONEK       (unsigned char)0xce
#define T61_ACCENT_CARON        (unsigned char)0xcf

#define T61_PI                  (unsigned char)0xe0
#define T61_CAP_AE              (unsigned char)0xe1
#define T61_CAP_D_BAR           (unsigned char)0xe2
#define T61_A_BAR               (unsigned char)0xe3
#define T61_CAP_H_BAR           (unsigned char)0xe4
#define T61_CAP_IJ              (unsigned char)0xe6
#define T61_CAP_L_DOT           (unsigned char)0xe7
#define T61_CAP_L_BAR           (unsigned char)0xe8
#define T61_CAP_O_BAR           (unsigned char)0xe9
#define T61_CAP_OE              (unsigned char)0xea
#define T61_O_BAR               (unsigned char)0xeb
#define T61_CAP_P_BAR           (unsigned char)0xec
#define T61_CAP_T_BAR           (unsigned char)0xed
#define T61_CAP_N_HOOK          (unsigned char)0xee
#define T61_LOWER_APOST_N       (unsigned char)0xef

#define T61_KAPPA               (unsigned char)0xf0
#define T61_LOWER_AE            (unsigned char)0xf1
#define T61_LOWER_D_BAR         (unsigned char)0xf2
#define T61_LOWER_DELTA_BAR     (unsigned char)0xf3
#define T61_LOWER_H_BAR         (unsigned char)0xf4
#define T61_LOWER_IH            (unsigned char)0xf5
#define T61_LOWER_IJ            (unsigned char)0xf6
#define T61_LOWER_L_DOT         (unsigned char)0xf7
#define T61_LOWER_L_BAR         (unsigned char)0xf8
#define T61_LOWER_O_BAR         (unsigned char)0xf9
#define T61_LOWER_OE            (unsigned char)0xfa
#define T61_BETA                (unsigned char)0xfb
#define T61_LOWER_P_BAR         (unsigned char)0xfc
#define T61_LOWER_T_BAR         (unsigned char)0xfd
#define T61_LOWER_N_HOOK        (unsigned char)0xfe

#define T61_CAP_A               (unsigned char)0x41
#define T61_CAP_B               (unsigned char)0x42
#define T61_CAP_C               (unsigned char)0x43
#define T61_CAP_D               (unsigned char)0x44
#define T61_CAP_E               (unsigned char)0x45
#define T61_CAP_F               (unsigned char)0x46
#define T61_CAP_G               (unsigned char)0x47
#define T61_CAP_H               (unsigned char)0x48
#define T61_CAP_I               (unsigned char)0x49
#define T61_CAP_J               (unsigned char)0x4a
#define T61_CAP_K               (unsigned char)0x4b
#define T61_CAP_L               (unsigned char)0x4c
#define T61_CAP_M               (unsigned char)0x4d
#define T61_CAP_N               (unsigned char)0x4e
#define T61_CAP_O               (unsigned char)0x4f
#define T61_CAP_P               (unsigned char)0x50
#define T61_CAP_Q               (unsigned char)0x51
#define T61_CAP_R               (unsigned char)0x52
#define T61_CAP_S               (unsigned char)0x53
#define T61_CAP_T               (unsigned char)0x54
#define T61_CAP_U               (unsigned char)0x55
#define T61_CAP_V               (unsigned char)0x56
#define T61_CAP_W               (unsigned char)0x57
#define T61_CAP_X               (unsigned char)0x58
#define T61_CAP_Y               (unsigned char)0x59
#define T61_CAP_Z               (unsigned char)0x5a

#define T61_LOWER_A             (unsigned char)0x61
#define T61_LOWER_B             (unsigned char)0x62
#define T61_LOWER_C             (unsigned char)0x63
#define T61_LOWER_D             (unsigned char)0x64
#define T61_LOWER_E             (unsigned char)0x65
#define T61_LOWER_F             (unsigned char)0x66
#define T61_LOWER_G             (unsigned char)0x67
#define T61_LOWER_H             (unsigned char)0x68
#define T61_LOWER_I             (unsigned char)0x69
#define T61_LOWER_J             (unsigned char)0x6a
#define T61_LOWER_K             (unsigned char)0x6b
#define T61_LOWER_L             (unsigned char)0x6c
#define T61_LOWER_M             (unsigned char)0x6d
#define T61_LOWER_N             (unsigned char)0x6e
#define T61_LOWER_O             (unsigned char)0x6f
#define T61_LOWER_P             (unsigned char)0x70
#define T61_LOWER_Q             (unsigned char)0x71
#define T61_LOWER_R             (unsigned char)0x72
#define T61_LOWER_S             (unsigned char)0x73
#define T61_LOWER_T             (unsigned char)0x74
#define T61_LOWER_U             (unsigned char)0x75
#define T61_LOWER_V             (unsigned char)0x76
#define T61_LOWER_W             (unsigned char)0x77
#define T61_LOWER_X             (unsigned char)0x78
#define T61_LOWER_Y             (unsigned char)0x79
#define T61_LOWER_Z             (unsigned char)0x7a

#define T61_BS                  (unsigned char)0x08
#define T61_LF                  (unsigned char)0x0a
#define T61_FF                  (unsigned char)0x0c
#define T61_CR                  (unsigned char)0x0d
#define T61_SUB                 (unsigned char)0x1a


#endif
