/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef ASN_NAMES_H_
#define ASN_NAMES_H_


#include <asnbase.h>
#include <asnstrng.h>


typedef enum {
  match_caseIgnore,
  match_caseExact,
} match_t;


int attr_lookup(r_buffer_t & s,
                unsigned char oid_separator_char,
                asn_oid & oid,
                match_t & match);

class EXPORTCLASS asn_AVA : public asn_sequence {
private:
  unsigned char attr_value_separator;
  unsigned char quote_mark;
  unsigned char open_quote_mark;
  unsigned char close_quote_mark;
  unsigned char oid_subident_separator;
  int unquote_IA5(r_buffer_t & src, buffer_t & dest) const;
  int unquote_BMP(r_buffer_t & src, buffer_t & dest) const;
  int unquote_Univ(r_buffer_t & src, buffer_t & dest) const;
  int unquote_UTF8(r_buffer_t & src, buffer_t & dest) const;
public:
  match_t matching_rule;
  asn_oid attr;
  asn_directoryString value;
  asn_AVA(security_t s = ASN_PUBLIC);
  virtual ~asn_AVA() {};
  bool operator == (const asn_AVA & o) const;
  bool operator != (const asn_AVA & o) const { return ! (*this == o); };
  int set_value_IA5(r_buffer_t & s);
  int set_value_BMP(r_buffer_t & s);
  int set_value_Univ(r_buffer_t & s);
  int set_value_UTF8(r_buffer_t & s);
  int get_value_IA5(buffer_t & s) const;
  int get_value_BMP(buffer_t & s) const;
  int get_value_Univ(buffer_t & s) const;
  int get_value_UTF8(buffer_t & s) const;
  int set_attr_value_separator(char c = '=');
  int set_attr_value_separator_IA5(unsigned char c);
  int set_quote_mark(char c = '\\');
  int set_quote_mark_IA5(unsigned char c);
  int set_open_quote_mark(char c = '\"');
  int set_open_quote_mark_IA5(unsigned char c);
  int set_close_quote_mark(char c = '\"');
  int set_close_quote_mark_IA5(unsigned char c);
  int set_oid_subident_separator(char c = '.');
  int set_oid_subident_separator_IA5(unsigned char c);
};


template class EXPORTCLASS asn_setof<asn_AVA>;

class EXPORTCLASS asn_RDN : public asn_setof<asn_AVA> {
private:
  unsigned char ava_separator;
  unsigned char attr_value_separator;
  unsigned char quote_mark;
  unsigned char open_quote_mark;
  unsigned char close_quote_mark;
  unsigned char oid_subident_separator;
protected:
  void propagate_syntax_options(void);
public:
  asn_RDN(security_t s = ASN_PUBLIC) : asn_setof<asn_AVA>(s) {
    strcpy(objType, "RDN");
    set_ava_separator();
    set_attr_value_separator();
    set_quote_mark();
    set_open_quote_mark();
    set_close_quote_mark();
    set_oid_subident_separator();
  };
  bool operator == (const asn_RDN & o) const;
  bool operator != (const asn_RDN & o) const { return ! (*this == o); };
  int set_value_IA5(r_buffer_t & s);
  int set_value_BMP(r_buffer_t & s);
  int set_value_Univ(r_buffer_t & s);
  int set_value_UTF8(r_buffer_t & s);
  int get_value_IA5(buffer_t & s) const;
  int get_value_BMP(buffer_t & s) const;
  int get_value_Univ(buffer_t & s) const;
  int get_value_UTF8(buffer_t & s) const;
  int set_ava_separator(char c = ',');
  int set_ava_separator_IA5(unsigned char c);
  int set_attr_value_separator(char c = '=');
  int set_attr_value_separator_IA5(unsigned char c);
  int set_quote_mark(char c = '\\');
  int set_quote_mark_IA5(unsigned char c);
  int set_open_quote_mark(char c = '\\');
  int set_open_quote_mark_IA5(unsigned char c);
  int set_close_quote_mark(char c = '\\');
  int set_close_quote_mark_IA5(unsigned char c);
  int set_oid_subident_separator(char c = '.');
  int set_oid_subident_separator_IA5(unsigned char c);
};

template class EXPORTCLASS asn_sequenceof<asn_RDN>;

class EXPORTCLASS asn_x500name : public asn_sequenceof<asn_RDN> {
private:
  unsigned char rdn_separator;
  unsigned char ava_separator;
  unsigned char attr_value_separator;
  unsigned char quote_mark;
  unsigned char open_quote_mark;
  unsigned char close_quote_mark;
  unsigned char oid_subident_separator;
  bool RdnBigEndian;
  bool leadingRdnSeparator;
protected:
  void propagate_syntax_options(void);
public:
  asn_x500name(security_t s = ASN_PUBLIC);
  virtual ~asn_x500name();
  int set_value_C(char * s, char splat = '?');
  int set_value_IA5(r_buffer_t & s);
  int set_value_BMP(r_buffer_t & s);
  int set_value_Univ(r_buffer_t & s);
  int set_value_UTF8(r_buffer_t & s);
  int get_value_IA5(buffer_t & s) const;
  int get_value_BMP(buffer_t & s) const;
  int get_value_Univ(buffer_t & s) const;
  int get_value_UTF8(buffer_t & s) const;
  bool operator ==(const asn_x500name & o) const;
  bool operator != (const asn_x500name & o) const { return ! (*this == o); };
  int get_parent(asn_x500name & p);
  int set_rdn_bigendian(bool bigendian = true);
  int set_leading_rdn_separator(bool b = true);
  int set_rdn_separator(char c = '/');
  int set_ava_separator(char c = ',');
  int set_attr_value_separator(char c = '=');
  int set_quote_mark(char c = '\\');
  int set_open_quote_mark(char c = '\"');
  int set_close_quote_mark(char c = '\"');
  int set_oid_subident_separator(char c = '.');
  int set_rdn_separator_IA5(unsigned char c);
  int set_ava_separator_IA5(unsigned char c);
  int set_attr_value_separator_IA5(unsigned char c);
  int set_open_quote_mark_IA5(unsigned char c);
  int set_close_quote_mark_IA5(unsigned char c);
  int set_quote_mark_IA5(unsigned char c);
  int set_oid_subident_separator_IA5(unsigned char c);
  void set_syntax_OSF(void);
  void set_syntax_1779(void);
};


#endif
