/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef ASN1_H_
#define ASN1_H_

#include <time.h>
#include <stddef.h>
#include <platform.h>

#include <asn1msg.h>

#define CLASS_UNIVERSAL 0
#define CLASS_APPLICATION 1
#define CLASS_CONTEXT_SPECIFIC 2
#define CLASS_PRIVATE 3


#define ASN_LITTLE_ENDIAN 1
#define ASN_BIG_ENDIAN 0


#define ASN_CHARSET_IA5 0
#define ASN_CHARSET_T61 0

#ifdef __cplusplus
extern "C" {
#endif

typedef struct asn_object_identifier_struct {
  uint32 length;
  void * elements;	
} asn_object_identifier_desc, *asn_object_identifier;
/* The above declaration is compatible with the CAT-WG's 
   gss_OID_desc type definition */


EXPORTFN(void, 
				 asn_free_oid, 
				 (asn_object_identifier o));
/* Frees storage associated with elements field of an OID, 
   and zeroes the length field */

EXPORTFN(int, 
				 asn_oid_equal, 
				 (asn_object_identifier o1, asn_object_identifier o2));
/* Returns true is o1 contains the same OID as o2, 
   false otherwise */

EXPORTFN(int,
				 AsnGetType,
				 (unsigned char ** p, uint32 * len, uint32 * ASNtype, int * constructed, int * ASNclass));
/* Given a length/pointer to an ASN1 octet stream, decodes
   the type field, and advances the length/pointer to the next
   element. */



EXPORTFN(int,
				 AsnGetLength,
				 (unsigned char ** p, uint32 * len, int * definite, uint32 * length));
/* Returns the length of the value. */


EXPORTFN(int,
				 AsnGetIntegerValue,
				 (unsigned char ** p, uint32 len, uint32 value_len, uint32 * value));
/* Gets an integer value, if it fits in an uint32 (otherwise 
   returns ASN_VALUE_OVERFLOW).  value_len should be the length 
   of the integer value (as returned by AsnGetLength). */


#ifdef __cplusplus
}

EXPORTFN(int,
				 AsnGetIntegerValue,
				 (unsigned char ** p, uint32 * len, uint32 value_len, 
				  unsigned char ** value, int endian = ASN_BIG_ENDIAN));
/* Gets an INTEGER value as an array of octets.
   value_len should be the length of
   the integer value (as returned by AsnGetLength). */

extern "C" {

#endif

EXPORTFN(int,
				 AsnGetLongIntegerValueBigEndian,
				 (unsigned char ** p, uint32 * len, uint32 value_len, unsigned char * value));

EXPORTFN(int,
				 AsnGetLongIntegerValueLittleEndian,
				 (unsigned char ** p, uint32 * len, uint32 value_len, unsigned char * value));

EXPORTFN(int,
				 AsnGetNullValue,
				 (unsigned char ** p, uint32 * len, uint32 value_len));
/* Gets a NULL value.  Since NULL doesn't actually encode a value,
   this is a trivial operation. */

EXPORTFN(int,
				 AsnGetBitstringValue,
				 (unsigned char ** p, uint32 * len, uint32 value_len, 
				  unsigned char ** value, uint32 * bit_count));
/* Reads a BITSTRING value.  Returns the number of bits in the
   string. */

EXPORTFN(int,
				 AsnGetOIDValue,
				 (unsigned char ** p, uint32 * len, uint32 value_len, asn_object_identifier o));


EXPORTFN(int,
				 AsnGetOctetstringValue,
				 (unsigned char ** p, uint32 * len, uint32 value_len,
          unsigned char ** value, uint32 * octet_count));
					 


EXPORTFN(int,
				 AsnGetCharstringValue,
				 (unsigned char ** p, uint32 * len, uint32 value_len, char ** value));


EXPORTFN(int,
				 UtcstrToLocTime,
				 (char * utcTime, struct tm * t));
/* Converts the utcTime string to a struct tm */




#ifdef __cplusplus
}
#endif

#endif