/* SCCSID: fwk/error/error.c, dss_cdsa_fwk, fwk_rel2, dss_971010 1.2 10/10/97 10:49:02 */
/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*-----------------------------------------------------------------------
 *      File:   ERROR.C
 *
 */
/*
 * (C) COPYRIGHT International Business Machines Corp. 1996, 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * Copyright (c) 1995, 1996, 1997 Intel Corporation. All rights reserved.
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */
/* 
 * WARNING: EXPORT RESTRICTED. 
 * This software listing contains cryptographic methods and technology. 
 * It is export restricted by the Office of Defense Trade Controls, United 
 * States Department of State and cannot be downloaded or otherwise 
 * exported or re-exported (i) into (or to a national or resident of) Cuba, 
 * Iraq, Libya, Yugoslavia, North Korea, Iran, Syria or any other country 
 * to which the US has embargoed goods; or (ii) to anyone on the US 
 * Treasury Department's list of Specially Designated Nationals or the US 
 * Commerce Department's Table of Denial Orders. By downloading or using 
 * this product, you are agreeing to the foregoing and you are representing 
 * and warranting that you are not located in, under the control of, or a 
 * national or resident of any such country or on any such list. 
 */ 

#include <stdlib.h>

#include "cssm.h"
#include "cssmport.h"

/* Error Handling */

#if defined (WIN32)
CSSM_THREAD CSSM_ERROR global_err;
#endif //WIN32
static CSSM_BOOL error_init = CSSM_FALSE;

/*-----------------------------------------------------------------------------
 * Name: CSSM_InitError
 *
 * Description:  Initializes the error infomation for a thread/process
 * 
 * Parameters: 
 * None
 *
 * Returns:
 * CSSM_OK if the function was successful.  
 * 
 * Error Codes:
 * None available
 *---------------------------------------------------------------------------*/

CSSM_RETURN CSSMAPI CSSM_InitError(void)
{

    global_err.error = CSSM_OK;
    cssm_memset(&(global_err.guid), 0, sizeof(CSSM_GUID));
    
    error_init = CSSM_TRUE;

    return(CSSM_OK);
}

/*-----------------------------------------------------------------------------
 * Name: CSSM_DestroyError
 *
 * Description:  Destroys the error infomation for a thread/process
 * 
 * Parameters: 
 * None
 *
 * Returns:
 * CSSM_OK if the function was successful. 
 * 
 * Error Codes:
 * None available
 *---------------------------------------------------------------------------*/

CSSM_RETURN CSSMAPI CSSM_DestroyError(void)
{

    error_init = CSSM_FALSE;
    return(CSSM_OK);
}

/*-----------------------------------------------------------------------------
 * Name: CSSM_GetError
 *
 * Description:  Gets the error infomation for a thread/process
 * 
 * Parameters: 
 * None
 *
 * Returns:
 * ptr to error infomation
 * NULL if CSSM_InitError was never called or CSSM_DestoryError has
 *   been called
 * 
 * Error Codes:
 * None available
 *---------------------------------------------------------------------------*/

CSSM_ERROR_PTR  CSSMAPI CSSM_GetError(void)
{

    if (error_init == CSSM_TRUE)
        return(&global_err);
    return(NULL);
}

/*-----------------------------------------------------------------------------
 * Name: CSSM_SetError
 *
 * Description:  Sets the error infomation for a thread/process
 * 
 * Parameters: 
 * None
 *
 * Returns:
 * CSSM_OK if the function was successful. 
 * CSSM_FAIL if an error condition occurred. 
 * 
 * Error Codes:
 * None available
 *---------------------------------------------------------------------------*/

CSSM_RETURN CSSMAPI CSSM_SetError(CSSM_GUID_PTR guid, uint32 error)
{

    if (error_init == CSSM_FALSE)
    {
        return(CSSM_FAIL);
    }

    if (!CSSM_IsCSSMError(error))
        if (!CSSM_IsCLError(error))
            if (!CSSM_IsDLError(error))
                if (!CSSM_IsCSPError(error))
                    if (!CSSM_IsTPError(error))
                        	return(CSSM_FAIL);
    /* if guid invalid, return CSSM_FAIL */
    global_err.error = error;
    cssm_memcpy(&(global_err.guid), guid, sizeof(CSSM_GUID));
    
    return(CSSM_OK);
}

/*-----------------------------------------------------------------------------
 * Name: CSSM_ClearError
 *
 * Description:  Clear the error infomation for a thread/process
 * 
 * Parameters: 
 * None
 *
 * Returns:
 * None
 *
 * Error Codes:
 * None available
 *---------------------------------------------------------------------------*/

void CSSMAPI CSSM_ClearError(void)
{

    global_err.error = CSSM_OK;
    cssm_memset(&(global_err.guid), 0, sizeof(CSSM_GUID));
    
    return;

}


