/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */



#ifndef MFC_PKCSPRIVATE_H
#define MFC_PKCSPRIVATE_H

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <time.h>

#ifndef RUNTIME_CSSM_SYMBOL_RESOLUTION
#ifndef IBMPKCS11_INSTALL
#define RUNTIME_CSSM_SYMBOL_RESOLUTION
#endif
#endif
#include <cssm.h>
#include <cssmspi.h>
#include <cssmcspi.h>
#include <cssmdli.h>
#include <cssmkeyformats.h>
#include <cssmport.h>



#define PKCS11_V20	
//#define STATIC_LINK
#define CK_ULONG CK_USHORT

#ifdef PKCS11_V20
#include "pkcsjnh.h"
#else
#include "cryptoki.h"
#endif

#include "pkcsvsc.h"
#include "random.h"



//
// Descriptions, etc.
//

#define PKCSMSM_VENDOR          "IBM Corporation"
#define PKCSMSM_DESCRIPTION     "CDSA Multi Service Module Wrapper for PKCS11 V2.X Tokens"
#define PKCSMSM_CSP_DESCRIPTION "IBM PKCS11 MSM - CSP Service"
#define PKCSMSM_DL_DESCRIPTION "IBM PKCS11 MSM - DL Service"
#define PKCSMSM_CSP_SUBSERVICE_DESCRIPTION "IBM PKCS11 MSM - CSP SubService"
#define PKCSMSM_DL_SUBSERVICE_DESCRIPTION "IBM PKCS11 MSM - DL SubService"
#define PKCSMSM_LABEL           ""
#define PKCSMSM_SERIALNUMBER    ""
#define PKCS_DESCRIPTION        "RSA Data Security, Inc. PKCS#11 V2.0"

//
// Macros
//

#define DIM(a)	(sizeof(a)/sizeof(a[0]))


//
// Strings
//

#define IBMPKCSMSMMUTEX			"IBMPKCSMSMMUTEX"

//
// Constants
//

#define NUMBEROFSERVICES		2

#define CSSMKEYHEADERVERSION	0x01

#define IVLEN					8
#define DESKEYLEN				8
#define DES2KEYLEN				16
#define DES3KEYLEN				24
#define RC2MINKEYLEN			1
#define RC2MAXKEYLEN			128
#define RC2EFFECTIVEKEYBITS		80
#define RC4MINKEYLEN			1
#define RC4MAXKEYLEN			256
#define RC5VERSION				0x10
#define RC5WORDSIZE				32
#define RC5MINKEYLEN			0
#define RC5MAXKEYLEN			255
#define RSAMINBITS				256
#define RSAMAXBITS				2048
#define DSAMINBITS				512
#define DSAMAXBITS				2048
#define DHPRIMEEXPDIFF			8
#define DHMINBITS				256
#define DHMAXBITS				2048

#define BITSPERBYTE				8
#define REMDATALEN				8
#define MDXDIGESTLEN			16
#define SHA1DIGESTLEN			20
#define SYMMETRICMACLEN			4

#define DEFAULTSEEDLEN			16			// THT001

#define DSASIGLEN				40			// THT002

#define IDEAKEYLEN				16
#define CDMFKEYLEN				8
#define SKIPJACKKEYLEN			10
#define BATONKEYLEN				20
#define JUNIPERKEYLEN			20

#define KEYIDLEN				16




//
// PKCS KEY OBJECT ATTRIBUTES 
//

#define PKCS_COMMON_OBJ_ATTRS		5

#define PKCS_COMMON_DATA_ATTRS		2
#define PKCS_TOTAL_DATA_ATTRS		(PKCS_COMMON_OBJ_ATTRS + PKCS_COMMON_DATA_ATTRS)

#define PKCS_COMMON_CERT_ATTRS		6
#define PKCS_TOTAL_CERT_ATTRS		(PKCS_COMMON_OBJ_ATTRS + PKCS_COMMON_CERT_ATTRS)

#define PKCS_COMMON_KEY_ATTRS		6
#define PKCS_COMMON_PUBLIC_ATTRS	5
#define PKCS_COMMON_PRIVATE_ATTRS	9
#define PKCS_COMMON_SECRET_ATTRS	10
#define PKCS_OTHER_PUBLIC_ATTRS		4
#define PKCS_OTHER_PRIVATE_ATTRS	8
#define PKCS_OTHER_SECRET_ATTRS		2
#define PKCS_TOTAL_PUBLIC_ATTRS		(PKCS_COMMON_OBJ_ATTRS + PKCS_COMMON_KEY_ATTRS +	\
									PKCS_COMMON_PUBLIC_ATTRS + PKCS_OTHER_PUBLIC_ATTRS)
#define PKCS_TOTAL_PRIVATE_ATTRS	(PKCS_COMMON_OBJ_ATTRS + PKCS_COMMON_KEY_ATTRS +	\
									PKCS_COMMON_PRIVATE_ATTRS + PKCS_OTHER_PRIVATE_ATTRS)
#define PKCS_TOTAL_SECRET_ATTRS		(PKCS_COMMON_OBJ_ATTRS + PKCS_COMMON_KEY_ATTRS +	\
									PKCS_COMMON_SECRET_ATTRS + PKCS_OTHER_SECRET_ATTRS)

#define CSSM_CSP_CANCEL						 ( CSSM_CSP_BASE_ERROR +459L )	
#define CSSM_CSP_NO_SLOTINFO		         ( CSSM_CSP_BASE_ERROR +460L )	

//
// PKCSMSM Session Structure & Functions
//

typedef struct MsmSession
{

// MSM Data
	CSSM_BOOL					bLogined;

// CSSM Data
	CSSM_MODULE_HANDLE			CssmModuleHandle;
	CSSM_HANDLEINFO				CssmHandleInfo;

	CSSM_CC_HANDLE				CssmCCHandle;

	CSSM_QUERY_FLAGS			CssmQueryFlags;

// PKCS Data
	CK_SESSION_HANDLE			PkcsSessionHandle;
	CK_SESSION_INFO				PkcsSessionInfo;

// Link Ptr
	struct MsmSession*			pNext;

} MSMSESSION, *MSMSESSION_PTR;

MSMSESSION_PTR CSSMAPI NewMsmSession(CSSM_MODULE_HANDLE	CssmModuleHandle);
void CSSMAPI DeleteMsmSession(MSMSESSION_PTR pMsmSession);
CSSM_RETURN CSSMAPI InsertMsmSession(MSMSESSION_PTR pMsmSession);
CSSM_RETURN CSSMAPI RemoveMsmSession(MSMSESSION_PTR pMsmSession);
MSMSESSION_PTR CSSMAPI FindMsmSession(CSSM_MODULE_HANDLE CssmModuleHandle);
MSMSESSION_PTR CSSMAPI FindMsmSession2(CK_SESSION_HANDLE PkcsSessionHandle);



//
// Error & Destructor Functions
//

void CSSMAPI Message(LPCTSTR msg);
CSSM_RETURN CSSMAPI SetErr(uint32 err);
void* CSSMAPI SetErrNull(uint32 err);
CSSM_HANDLE CSSMAPI SetErrNullHandle(uint32 err);
CSSM_BOOL CSSMAPI SetErrFalse(uint32 err);
CSSM_RETURN CSSMAPI Destruct(MSMSESSION_PTR pMsmSession);
CSSM_RETURN CSSMAPI ErrDestruct(MSMSESSION_PTR pMsmSession, uint32 err);



//
// Miscellaneous Functions
//

CSSM_RETURN GetSeed(CSSM_DATA_PTR pSeed);


void SetupKeyHeader(
	CSSM_KEYHEADER_PTR	pKeyHeader, 
	uint32				BlobType,			/* See BlobType #define's */
	uint32				Format,				/* Raw or Reference format */
	uint32				AlgorithmId,		/* Algoritm ID of key */
	uint32				KeyClass,			/* Public/Private/Secret etc. */
	uint32				KeySizeInBits,		/* Size of actual key/modulus/prime in bits */
	uint32				KeyAttr,			/* Attribute flags */
	uint32				KeyUsage,			/* Key use flags */
	CSSM_DATE			*StartDate,			/* Effective date of key */
	CSSM_DATE			*EndDate,			/* Expiration date of key */
	uint32				WrapAlgorithmId,	/* CSSM_ALGID_XXX */
	uint32				WrapMode);			/* CSSM_ALGMODE_XXX */




//
//
// Module Management
//
//

CSSM_RETURN CSSMAPI Initialize(
	CSSM_MODULE_HANDLE CssmHandle,
	uint32 CssmVerMajor,
    uint32 CssmVerMinor);

CSSM_RETURN CSSMAPI Terminate(
	CSSM_MODULE_HANDLE CssmHandle);

CSSM_RETURN CSSMAPI EventNotify(
	CSSM_CSP_HANDLE CssmCSPHandle,
    const CSSM_EVENT_TYPE CssmEvent,
    const uint32 CssmParam);

CSSM_MODULE_INFO_PTR CSSMAPI GetMsmInfo(
	CSSM_MODULE_HANDLE CssmModuleHandle,
	CSSM_SERVICE_MASK CssmServiceMask,
    uint32 CssmSubserviceID,
    CSSM_INFO_LEVEL CssmInfoLevel);

CSSM_RETURN CSSMAPI Login(
	CSSM_CSP_HANDLE CssmCSPHandle,
    const CSSM_CRYPTO_DATA_PTR pCssmPassword,
    const CSSM_DATA_PTR pCssmReserved);

CSSM_RETURN CSSMAPI Logout(
	CSSM_CSP_HANDLE CssmCSPHandle);
    
CSSM_RETURN CSSMAPI ChangeLoginPassword(
	CSSM_CSP_HANDLE CssmCSPHandle,
    const CSSM_CRYPTO_DATA_PTR pCssmOldPassword,
    const CSSM_CRYPTO_DATA_PTR pCssmNewPassword);


//
//
// Cryptographic Functions
//
//


//
// Decrypt
//

CSSM_RETURN CSSMAPI DecryptData(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmCipherBufs,
	uint32 CssmCipherBufCount,
	CSSM_DATA_PTR pCssmClearBufs,
	uint32 CssmClearBufCount,
	uint32 *pCssmBytesDecrypted,
	CSSM_DATA_PTR pCssmRemData);

CSSM_RETURN CSSMAPI DecryptDataAsymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmCipherBufs,
	uint32 CssmCipherBufCount,
	CSSM_DATA_PTR pCssmClearBufs,
	uint32 CssmClearBufCount,
	uint32 *pCssmBytesDecrypted,
	CSSM_DATA_PTR pCssmRemData);

CSSM_RETURN CSSMAPI DecryptDataSymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmCipherBufs,
	uint32 CssmCipherBufCount,
	CSSM_DATA_PTR pCssmClearBufs,
	uint32 CssmClearBufCount,
	uint32 *pCssmBytesDecrypted,
	CSSM_DATA_PTR pCssmRemData);

CSSM_RETURN CSSMAPI DecryptDataInitSymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext);

CSSM_RETURN CSSMAPI DecryptDataUpdateSymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_DATA_PTR pCssmCipherBufs,
	uint32 CssmCipherBufCount,
	CSSM_DATA_PTR pCssmClearBufs,
	uint32 CssmClearBufCount,
	uint32 *pCssmBytesDecrypted);

CSSM_RETURN CSSMAPI DecryptDataFinalSymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	CSSM_DATA_PTR pCssmRemData);


//
// Digest
//

CSSM_RETURN CSSMAPI DigestData(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount,
	CSSM_DATA_PTR pCssmDigest);

CSSM_RETURN CSSMAPI DigestDataInit(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext);

CSSM_RETURN CSSMAPI DigestDataUpdate(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount);

CSSM_RETURN CSSMAPI DigestDataFinal(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	CSSM_DATA_PTR pCssmDigest);


//
// Encrypt
//

CSSM_RETURN CSSMAPI EncryptData(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmClearBufs,
	uint32 CssmClearBufCount,
	CSSM_DATA_PTR pCssmCipherBufs,
	uint32 CssmCipherBufCount,
	uint32 *pCssmBytesEncrypted,
	CSSM_DATA_PTR pCssmRemData);

CSSM_RETURN CSSMAPI EncryptDataAsymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmClearBufs,
	uint32 CssmClearBufCount,
	CSSM_DATA_PTR pCssmCipherBufs,
	uint32 CssmCipherBufCount,
	uint32 *pCssmBytesEncrypted,
	CSSM_DATA_PTR pCssmRemData);

CSSM_RETURN CSSMAPI EncryptDataSymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmClearBufs,
	uint32 CssmClearBufCount,
	CSSM_DATA_PTR pCssmCipherBufs,
	uint32 CssmCipherBufCount,
	uint32 *pCssmBytesEncrypted,
	CSSM_DATA_PTR pCssmRemData);

CSSM_RETURN CSSMAPI EncryptDataInitSymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext);

CSSM_RETURN CSSMAPI EncryptDataInitAsymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext);

CSSM_RETURN CSSMAPI EncryptDataUpdateSymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_DATA_PTR pCssmClearBufs,
	uint32 CssmClearBufCount,
	CSSM_DATA_PTR pCssmCipherBufs,
	uint32 CssmCipherBufCount,
	uint32 *pCssmBytesEncrypted);

CSSM_RETURN CSSMAPI EncryptDataFinalSymmetric(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	CSSM_DATA_PTR pCssmRemData);


//
// Key Management
//


CSSM_RETURN CSSMAPI QueryKeySizeInBits(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
    CSSM_KEY_SIZE_PTR CssmKeySize);

CSSM_RETURN CSSMAPI DeriveKey(
	CSSM_CSP_HANDLE CssmCSPHandle,
    CSSM_CC_HANDLE CssmCCHandle,
    const CSSM_CONTEXT_PTR pCssmContext,
    const CSSM_KEY_PTR pCssmBaseKey,
    CSSM_DATA_PTR pCssmParam,
    uint32 CssmKeyUsage,
    uint32 CssmKeyAttr,
	const CSSM_DATA_PTR pCssmKeyLabel,
    CSSM_KEY_PTR pCssmDerivedKey);

CSSM_RETURN CSSMAPI GenerateKey(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	uint32 CssmKeyUsage,
    uint32 CssmKeyAttr,
	const CSSM_DATA_PTR pCssmKeyLabel,
	CSSM_KEY_PTR pCssmKey);

CSSM_RETURN CSSMAPI GenerateKeyPair(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	uint32 CssmPublicKeyUsage,
    uint32 CssmPublicKeyAttr,
	const CSSM_DATA_PTR pCssmPublicKeyLabel,
	CSSM_KEY_PTR pCssmPublicKey,
	uint32 CssmPrivateKeyUsage,
    uint32 CssmPrivateKeyAttr,
	const CSSM_DATA_PTR pCssmPrivateKeyLabel,
	CSSM_KEY_PTR pCssmPrivateKey);

CSSM_RETURN CSSMAPI WrapKey(
	CSSM_CSP_HANDLE CssmCSPHandle,
    CSSM_CC_HANDLE CssmCCHandle,
    const CSSM_CONTEXT_PTR pCssmContext,
    const CSSM_CRYPTO_DATA_PTR pCssmPassPhrase, 
    const CSSM_KEY_PTR pCssmKey,
    CSSM_WRAP_KEY_PTR pCssmWrappedKey);

CSSM_RETURN CSSMAPI UnwrapKey(
	CSSM_CSP_HANDLE CssmCSPHandle, 
    CSSM_CC_HANDLE CssmCCHandle,
    const CSSM_CONTEXT_PTR pCssmContext,
    const CSSM_CRYPTO_DATA_PTR pCssmNewPassPhrase,
    const CSSM_WRAP_KEY_PTR pCssmWrappedKey,
    uint32 CssmStorageMask,
	const CSSM_DATA_PTR pCssmKeyLabel,
    CSSM_KEY_PTR pCssmUnwrappedKey);

CSSM_RETURN CSSMAPI GenerateRandom(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	CSSM_DATA_PTR pCssmRandomNumber);


//
// PassThrough
//

void* CSSMAPI PassThrough(
	CSSM_CSP_HANDLE CssmCSPHandle, 
    CSSM_CC_HANDLE CssmCCHandle,
    const CSSM_CONTEXT_PTR pCssmContext,
    uint32 CssmPassThroughId,
    const void* pCssmInData);

//
// Sign
//

CSSM_RETURN CSSMAPI SignData(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount,
	CSSM_DATA_PTR pCssmSignature);

CSSM_RETURN CSSMAPI SignDataSinglePart(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount,
	CSSM_DATA_PTR pCssmSignature);

CSSM_RETURN CSSMAPI SignDataInit(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext);

CSSM_RETURN CSSMAPI SignDataUpdate(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount);

CSSM_RETURN CSSMAPI SignDataFinal(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	CSSM_DATA_PTR pCssmSignature);



//
// Verify
//

CSSM_BOOL CSSMAPI VerifyData(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount,
	const CSSM_DATA_PTR pCssmSignature);

CSSM_BOOL CSSMAPI VerifyDataSinglePart(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount,
	CSSM_DATA_PTR pCssmSignature);

CSSM_RETURN CSSMAPI VerifyDataInit(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext);

CSSM_RETURN CSSMAPI VerifyDataUpdate(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount);

CSSM_BOOL CSSMAPI VerifyDataFinal(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_DATA_PTR pCssmSignature);


//
// GenerateMac
//

CSSM_RETURN CSSMAPI GenerateMac(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount,
	CSSM_DATA_PTR pCssmMac);

CSSM_RETURN CSSMAPI GenerateMacInit(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext);

CSSM_RETURN CSSMAPI GenerateMacUpdate(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount);

CSSM_RETURN CSSMAPI GenerateMacFinal(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	CSSM_DATA_PTR pCssmMac);



//
// VerifyMac
//

CSSM_RETURN CSSMAPI VerifyMac(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount,
	CSSM_DATA_PTR pCssmMac);

CSSM_RETURN CSSMAPI VerifyMacInit(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_CONTEXT_PTR pCssmContext);

CSSM_RETURN CSSMAPI VerifyMacUpdate(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	const CSSM_DATA_PTR pCssmDataBufs,
	uint32 CssmDataBufCount);

CSSM_RETURN CSSMAPI VerifyMacFinal(
	CSSM_CSP_HANDLE CssmCSPHandle,
	CSSM_CC_HANDLE CssmCCHandle,
	CSSM_DATA_PTR pCssmMac);

//
// DL
//

CSSM_DB_HANDLE CSSMAPI DbOpen(
	CSSM_DL_HANDLE CssmDLHandle,
    const char *pCssmDbName,
    const CSSM_DB_ACCESS_TYPE_PTR pCssmAccessRequest,
    const CSSM_USER_AUTHENTICATION_PTR pCssmUserAuthentication,
    const void *pCssmOpenParameters);

CSSM_RETURN CSSMAPI DbClose(
	CSSM_DL_DB_HANDLE CssmDLDBHandle);

CSSM_DB_UNIQUE_RECORD_PTR CSSMAPI DataInsert (
    CSSM_DL_DB_HANDLE CssmDLDBHandle,
    const CSSM_DB_RECORDTYPE CssmRecordType,
    const CSSM_DB_RECORD_ATTRIBUTE_DATA_PTR pCssmAttributes, 
    const CSSM_DATA_PTR pCssmData);

CSSM_RETURN CSSMAPI DataDelete (
    CSSM_DL_DB_HANDLE CssmDLDBHandle,
	CSSM_DB_RECORDTYPE CssmRecordType,
    const CSSM_DB_UNIQUE_RECORD_PTR pCssmUniqueRecordId);

CSSM_DB_UNIQUE_RECORD_PTR CSSMAPI DataGetFirst (
    CSSM_DL_DB_HANDLE CssmDLDBHandle,
    const CSSM_QUERY_PTR pCssmQuery,
    CSSM_HANDLE_PTR pCssmResultsHandle,
    CSSM_BOOL* pCssmEndOfDataStore,
    CSSM_DB_RECORD_ATTRIBUTE_DATA_PTR pCssmAttributes,
    CSSM_DATA_PTR pCssmData);

CSSM_DB_UNIQUE_RECORD_PTR CSSMAPI DataGetNext (
    CSSM_DL_DB_HANDLE pCssmDLDBHandle,
    CSSM_HANDLE CssmResultsHandle,
    CSSM_BOOL *pCssmEndOfDataStore,
    CSSM_DB_RECORD_ATTRIBUTE_DATA_PTR pCssmAttributes,		
    CSSM_DATA_PTR pCssmData);

CSSM_RETURN CSSMAPI DataAbortQuery(
	CSSM_DL_DB_HANDLE CssmDLDBHandle,
    CSSM_HANDLE ResultsHandle);


#ifdef PKCS11_V20

CK_RV CK_ENTRY C_CreateFips140Object(CK_SESSION_HANDLE hSession,
                                  CK_ATTRIBUTE_PTR pTemplate,
                                  CK_ULONG ulCount,
                                  CK_OBJECT_HANDLE_PTR phObject);

#else

CK_RV CK_ENTRY C_CreateFips140Object(CK_SESSION_HANDLE hSession,
							      CK_ATTRIBUTE_PTR pTemplate,
                                  CK_USHORT usCount,
                                  CK_OBJECT_HANDLE_PTR phObject);

typedef CK_RV CK_ENTRY (* CK_C_Initialize)(
	CK_VOID_PTR pReserved
);

typedef CK_RV CK_ENTRY (* CK_C_GetInfo)(
	CK_INFO_PTR pInfo
);

typedef CK_RV CK_ENTRY (* CK_C_GetSlotList)(
	CK_BBOOL tokenPresent,
	CK_SLOT_ID_PTR pSlotList,
	CK_USHORT_PTR pusCount
);

typedef CK_RV CK_ENTRY (* CK_C_GetSlotInfo)(
	CK_SLOT_ID slotID,
	CK_SLOT_INFO_PTR pInfo
);

typedef CK_RV CK_ENTRY (* CK_C_GetTokenInfo)(
	CK_SLOT_ID slotID,
	CK_TOKEN_INFO_PTR pInfo
);


typedef CK_RV CK_ENTRY (* CK_C_GetMechanismList)(
	CK_SLOT_ID slotID,
	CK_MECHANISM_TYPE_PTR pMechanismList,
	CK_USHORT_PTR pusCount
);


typedef CK_RV CK_ENTRY (* CK_C_GetMechanismInfo)(
	CK_SLOT_ID slotID,
	CK_MECHANISM_TYPE type,
	CK_MECHANISM_INFO_PTR pInfo
);


typedef CK_RV CK_ENTRY (* CK_C_InitToken)(
	CK_SLOT_ID slotID,
	CK_CHAR_PTR pPin,
	CK_USHORT usPinLen,
	CK_CHAR_PTR pLabel
);


typedef CK_RV CK_ENTRY (* CK_C_InitPIN)(
	CK_SESSION_HANDLE hSession,
	CK_CHAR_PTR pPin,
	CK_USHORT usPinLen
);


typedef CK_RV CK_ENTRY (* CK_C_SetPIN)(
	CK_SESSION_HANDLE hSession,
	CK_CHAR_PTR pOldPin,
	CK_USHORT usOldLen,
	CK_CHAR_PTR pNewPin,
	CK_USHORT usNewLen
);


typedef CK_RV CK_ENTRY (* CK_C_OpenSession)(
	CK_SLOT_ID slotID,
	CK_FLAGS flags,
	CK_VOID_PTR pApplication,
	CK_RV (*Notify)(CK_SESSION_HANDLE hSession,
	   CK_NOTIFICATION event, CK_VOID_PTR pApplication),
	CK_SESSION_HANDLE_PTR phSession
);


typedef CK_RV CK_ENTRY (* CK_C_CloseSession)(
	CK_SESSION_HANDLE hSession
);


typedef CK_RV CK_ENTRY (* CK_C_CloseAllSessions)(
	CK_SLOT_ID slotID
);


typedef CK_RV CK_ENTRY (* CK_C_GetSessionInfo)(
	CK_SESSION_HANDLE hSession,
	CK_SESSION_INFO_PTR pInfo
);


typedef CK_RV CK_ENTRY (* CK_C_Login)(
	CK_SESSION_HANDLE hSession,
	CK_USER_TYPE userType,
	CK_CHAR_PTR pPin,
	CK_USHORT usPinLen
);


typedef CK_RV CK_ENTRY (* CK_C_Logout)(
	CK_SESSION_HANDLE hSession
);


typedef CK_RV CK_ENTRY (* CK_C_CreateObject)(
	CK_SESSION_HANDLE hSession,
	CK_ATTRIBUTE_PTR pTemplate,
	CK_USHORT usCount,
	CK_OBJECT_HANDLE_PTR phObject
);


typedef CK_RV CK_ENTRY (* CK_C_CopyObject)(
	CK_SESSION_HANDLE hSession,
	CK_OBJECT_HANDLE hObject,
	CK_ATTRIBUTE_PTR pTemplate,
	CK_USHORT usCount,
	CK_OBJECT_HANDLE_PTR phNewObject
);


typedef CK_RV CK_ENTRY (* CK_C_DestroyObject)(
	CK_SESSION_HANDLE hSession,
	CK_OBJECT_HANDLE hObject
);


typedef CK_RV CK_ENTRY (* CK_C_GetObjectSize)(
	CK_SESSION_HANDLE hSession,
	CK_OBJECT_HANDLE hObject,
	CK_USHORT_PTR pusSize
);


typedef CK_RV CK_ENTRY (* CK_C_GetAttributeValue)(
	CK_SESSION_HANDLE hSession,
	CK_OBJECT_HANDLE hObject,
	CK_ATTRIBUTE_PTR pTemplate,
	CK_USHORT usCount
);


typedef CK_RV CK_ENTRY (* CK_C_SetAttributeValue)(
	CK_SESSION_HANDLE hSession,
	CK_OBJECT_HANDLE hObject,
	CK_ATTRIBUTE_PTR pTemplate,
	CK_USHORT usCount
);


typedef CK_RV CK_ENTRY (* CK_C_FindObjectsInit)(
	CK_SESSION_HANDLE hSession,
	CK_ATTRIBUTE_PTR pTemplate,
	CK_USHORT usCount
);


typedef CK_RV CK_ENTRY (* CK_C_FindObjects)(
	CK_SESSION_HANDLE hSession,
	CK_OBJECT_HANDLE_PTR phObject,
	CK_USHORT usMaxObjectCount,
	CK_USHORT_PTR pusObjectCount
);


typedef CK_RV CK_ENTRY (* CK_C_FindObjectsFinal)(
	CK_SESSION_HANDLE hSession
);


typedef CK_RV CK_ENTRY (* CK_C_EncryptInit)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_OBJECT_HANDLE hKey
);


typedef CK_RV CK_ENTRY (* CK_C_Encrypt)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pData,
	CK_USHORT usDataLen,
	CK_BYTE_PTR pEncryptedData,
	CK_USHORT_PTR pusEncryptedDataLen
);


typedef CK_RV CK_ENTRY (* CK_C_EncryptUpdate)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pPart,
	CK_USHORT usPartLen,
	CK_BYTE_PTR pEncryptedPart,
	CK_USHORT_PTR pusEncryptedPartLen
);


typedef CK_RV CK_ENTRY (* CK_C_EncryptFinal)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pLastEncryptedPart,
	CK_USHORT_PTR pusEncryptedPartLen
);


typedef CK_RV CK_ENTRY (* CK_C_DecryptInit)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_OBJECT_HANDLE hKey
);


typedef CK_RV CK_ENTRY (* CK_C_Decrypt)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pEncryptedData,
	CK_USHORT usEncryptedDataLen,
	CK_BYTE_PTR pData,
	CK_USHORT_PTR pusDataLen
);


typedef CK_RV CK_ENTRY (* CK_C_DecryptUpdate)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pEncryptedPart,
	CK_USHORT usEncryptedPartLen,
	CK_BYTE_PTR pPart,
	CK_USHORT_PTR pusPartLen
);


typedef CK_RV CK_ENTRY (* CK_C_DecryptFinal)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pLastPart,
	CK_USHORT_PTR usLastPartLen
);


typedef CK_RV CK_ENTRY (* CK_C_DigestInit)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism
);


typedef CK_RV CK_ENTRY (* CK_C_Digest)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pData,
	CK_USHORT usDataLen,
	CK_BYTE_PTR pDigest,
	CK_USHORT_PTR pusDigestLen
);


typedef CK_RV CK_ENTRY (* CK_C_DigestUpdate)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pPart,
	CK_USHORT usPartLen
);


typedef CK_RV CK_ENTRY (* CK_C_DigestFinal)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pDigest,
	CK_USHORT_PTR pusDigestLen
);


typedef CK_RV CK_ENTRY (* CK_C_SignInit)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_OBJECT_HANDLE hKey
);


typedef CK_RV CK_ENTRY (* CK_C_Sign)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pData,
	CK_USHORT usDataLen,
	CK_BYTE_PTR pSignature,
	CK_USHORT_PTR pusSignatureLen
);


typedef CK_RV CK_ENTRY (* CK_C_SignUpdate)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pPart,
	CK_USHORT usPartLen
);


typedef CK_RV CK_ENTRY (* CK_C_SignFinal)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pSignature,
	CK_USHORT_PTR pusSignatureLen
);


typedef CK_RV CK_ENTRY (* CK_C_SignRecoverInit)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_OBJECT_HANDLE hKey
);


typedef CK_RV CK_ENTRY (* CK_C_SignRecover)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pData,
	CK_USHORT usDataLen,
	CK_BYTE_PTR pSignature,
	CK_USHORT_PTR pusSignatureLen
);


typedef CK_RV CK_ENTRY (* CK_C_VerifyInit)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_OBJECT_HANDLE hKey
);


typedef CK_RV CK_ENTRY (* CK_C_Verify)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pData,
	CK_USHORT usDataLen,
	CK_BYTE_PTR pSignature,
	CK_USHORT usSignatureLen
);


typedef CK_RV CK_ENTRY (* CK_C_VerifyUpdate)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pPart,
	CK_USHORT usPartLen
);


typedef CK_RV CK_ENTRY (* CK_C_VerifyFinal)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pSignature,
	CK_USHORT usSignatureLen
);


typedef CK_RV CK_ENTRY (* CK_C_VerifyRecoverInit)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_OBJECT_HANDLE hKey
);


typedef CK_RV CK_ENTRY (* CK_C_VerifyRecover)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pSignature,
	CK_USHORT usSignatureLen,
	CK_BYTE_PTR pData,
	CK_USHORT_PTR pusDataLen
);


typedef CK_RV CK_ENTRY (* CK_C_GenerateKey)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_ATTRIBUTE_PTR pTemplate,
	CK_USHORT usCount,
	CK_OBJECT_HANDLE_PTR phKey
);


typedef CK_RV CK_ENTRY (* CK_C_GenerateKeyPair)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_ATTRIBUTE_PTR pPublicKeyTemplate,
	CK_USHORT usPublicKeyAttributeCount,
	CK_ATTRIBUTE_PTR pPrivateKeyTemplate,
	CK_USHORT usPrivateKeyAttributeCount,
	CK_OBJECT_HANDLE_PTR phPrivateKey,
	CK_OBJECT_HANDLE_PTR phPublicKey
);


typedef CK_RV CK_ENTRY (* CK_C_WrapKey)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_OBJECT_HANDLE hWrappingKey,
	CK_OBJECT_HANDLE hKey,
	CK_BYTE_PTR pWrappedKey,
	CK_USHORT_PTR pusWrappedKeyLen
);


typedef CK_RV CK_ENTRY (* CK_C_UnwrapKey)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_OBJECT_HANDLE hUnwrappingKey,
	CK_BYTE_PTR pWrappedKey,
	CK_USHORT usWrappedKeyLen,
	CK_ATTRIBUTE_PTR pTemplate,
	CK_USHORT usAttributeCount,
	CK_OBJECT_HANDLE_PTR phKey
);


typedef CK_RV CK_ENTRY (* CK_C_DeriveKey)(
	CK_SESSION_HANDLE hSession,
	CK_MECHANISM_PTR pMechanism,
	CK_OBJECT_HANDLE hBaseKey,
	CK_ATTRIBUTE_PTR pTemplate,
	CK_USHORT usAttributeCount,
	CK_OBJECT_HANDLE_PTR phKey
);


typedef CK_RV CK_ENTRY (* CK_C_SeedRandom)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pSeed,
	CK_USHORT usSeedLen
);


typedef CK_RV CK_ENTRY (* CK_C_GenerateRandom)(
	CK_SESSION_HANDLE hSession,
	CK_BYTE_PTR pRandomData,
	CK_USHORT usRandomLen
);


typedef CK_RV CK_ENTRY (* CK_C_GetFunctionStatus)(
	CK_SESSION_HANDLE hSession
);


typedef CK_RV CK_ENTRY (* CK_C_CancelFunction)(
	CK_SESSION_HANDLE hSession
);


//
// CK_FUNCTION_LIST
//

typedef struct ck_function_list {
	CK_VERSION					version;			/* Cryptoki version */
	CK_C_Initialize				C_Initialize;
	CK_C_GetInfo				C_GetInfo;
	CK_C_GetSlotList			C_GetSlotList;
	CK_C_GetSlotInfo			C_GetSlotInfo;
	CK_C_GetTokenInfo			C_GetTokenInfo;
	CK_C_GetMechanismList		C_GetMechanismList;
	CK_C_GetMechanismInfo		C_GetMechanismInfo;
	CK_C_InitToken				C_InitToken;
	CK_C_InitPIN				C_InitPIN;
	CK_C_SetPIN					C_SetPIN;
	CK_C_OpenSession			C_OpenSession;
	CK_C_CloseSession			C_CloseSession;
	CK_C_CloseAllSessions		C_CloseAllSessions;
	CK_C_GetSessionInfo			C_GetSessionInfo;
	CK_C_Login					C_Login;
	CK_C_Logout					C_Logout;
	CK_C_CreateObject			C_CreateObject;
	CK_C_CopyObject				C_CopyObject;
	CK_C_DestroyObject			C_DestroyObject;	
	CK_C_GetObjectSize			C_GetObjectSize;
	CK_C_GetAttributeValue		C_GetAttributeValue;
	CK_C_SetAttributeValue		C_SetAttributeValue;
	CK_C_FindObjectsInit		C_FindObjectsInit;
	CK_C_FindObjects			C_FindObjects;
	CK_C_FindObjectsFinal		C_FindObjectsFinal;
	CK_C_EncryptInit			C_EncryptInit;
	CK_C_Encrypt				C_Encrypt;
	CK_C_EncryptUpdate			C_EncryptUpdate;
	CK_C_EncryptFinal			C_EncryptFinal;
	CK_C_DecryptInit			C_DecryptInit;
	CK_C_Decrypt				C_Decrypt;
	CK_C_DecryptUpdate			C_DecryptUpdate;
	CK_C_DecryptFinal			C_DecryptFinal;
	CK_C_DigestInit				C_DigestInit;
	CK_C_Digest					C_Digest;
	CK_C_DigestUpdate			C_DigestUpdate;
	CK_C_DigestFinal			C_DigestFinal;
	CK_C_SignInit				C_SignInit;
	CK_C_Sign					C_Sign;
	CK_C_SignUpdate				C_SignUpdate;
	CK_C_SignFinal				C_SignFinal;
	CK_C_SignRecoverInit		C_SignRecoverInit;
	CK_C_SignRecover			C_SignRecover;
	CK_C_VerifyInit				C_VerifyInit;
	CK_C_Verify					C_Verify;
	CK_C_VerifyUpdate			C_VerifyUpdate;
	CK_C_VerifyFinal			C_VerifyFinal;
	CK_C_VerifyRecoverInit		C_VerifyRecoverInit;
	CK_C_VerifyRecover			C_VerifyRecover;
	CK_C_GenerateKey			C_GenerateKey;
	CK_C_GenerateKeyPair		C_GenerateKeyPair;
	CK_C_WrapKey				C_WrapKey;
	CK_C_UnwrapKey				C_UnwrapKey;
	CK_C_DeriveKey				C_DeriveKey;
	CK_C_SeedRandom				C_SeedRandom;
	CK_C_GenerateRandom			C_GenerateRandom;
	CK_C_GetFunctionStatus		C_GetFunctionStatus;
	CK_C_CancelFunction			C_CancelFunction;
} CK_FUNCTION_LIST, *CK_FUNCTION_LIST_PTR;

#define CKR_FUNCTION_NOT_SUPPORTED            0x00000054
CSSM_RETURN	SetupFuncList(LPCTSTR lpLibFileName);

#endif

// Declarations of CSSM functions
//#ifdef RUNTIME_CSSM_SYMBOL_RESOLUTION
#ifndef IBMPKCS11_INSTALL

typedef CSSM_RETURN (CSSMAPI *CSSM_SETERROR)(CSSM_GUID_PTR, uint32);
typedef void (CSSMAPI *CSSM_CLEARERROR)(void);
typedef CSSM_CONTEXT_PTR (CSSMAPI *CSSM_GETCONTEXT)(CSSM_CC_HANDLE);
typedef CSSM_RETURN (CSSMAPI *CSSM_FREECONTEXT)(CSSM_CONTEXT_PTR);
typedef CSSM_CONTEXT_ATTRIBUTE_PTR (CSSMAPI *CSSM_GETCONTEXTATTRIBUTE)(
                                            const CSSM_CONTEXT_PTR, uint32);
typedef CSSM_RETURN (CSSMAPI *CSSM_REGISTERSERVICES)(
                             const CSSM_GUID_PTR GUID,
                             const CSSM_REGISTRATION_INFO_PTR FunctionTable,
                             CSSM_SPI_MEMORY_FUNCS_PTR UpcallTable,
                             void *Reserved);

typedef CSSM_RETURN (CSSMAPI *CSSM_DEREGISTERSERVICES)(const CSSM_GUID_PTR GUID);

typedef CSSM_HANDLEINFO_PTR (CSSMAPI *CSSM_GETHANDLEINFO)(CSSM_HANDLE hModule);

CSSM_SETERROR				CSSM_SetError;
CSSM_CLEARERROR				CSSM_ClearError;        
CSSM_GETCONTEXT				CSSM_GetContext;
CSSM_FREECONTEXT			CSSM_FreeContext;
CSSM_GETCONTEXTATTRIBUTE	CSSM_GetContextAttribute;
CSSM_REGISTERSERVICES		CSSM_RegisterServices;
CSSM_DEREGISTERSERVICES		CSSM_DeregisterServices;
CSSM_GETHANDLEINFO			CSSM_GetHandleInfo;

#endif

#endif
