/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */



#include "pkcsprivate.h"

extern CSSM_SPI_MEMORY_FUNCS CssmMemFuncs;
int defaultSeed[DEFAULTSEEDLEN];



/*****************************************************************************
 * Function: GetSeed 
 *
 * Get seed for random number generation.
 *
 * Input:
 *  pCssmContext    - Pointer to context 
 *   
 * Output:
 *  pSeed       - Seed 
 *   
 * Returns:
 *  None        
 *
 */

CSSM_RETURN GetSeed(CSSM_DATA_PTR pSeed)
{
  return CSSM_OK;
}



/*****************************************************************************
 * Function: GenerateRandom 
 * 
 * Generate random number.
 *
 * Input:
 *  CssmCSPHandle   - Attach session handle 
 *  CssmCCHandle    - Context handle
 *  pCssmContext    - Pointer to context 
 *   
 * Output:
 *  pCssmRandomNumber - Generated random number if successful
 *   
 * Returns:
 *  CSSM_OK       - Successful      
 *  CSSM_FAIL     - Failed
 *
 */

CSSM_RETURN CSSMAPI GenerateRandom(
  CSSM_CSP_HANDLE CssmCSPHandle,
  CSSM_CC_HANDLE CssmCCHandle,
  const CSSM_CONTEXT_PTR pCssmContext,
  CSSM_DATA_PTR pCssmRandomNumber)
{
  MSMSESSION_PTR        pMsmSession;
  CSSM_BOOL         MsmBufferAllocated = CSSM_FALSE;

  CSSM_CONTEXT_ATTRIBUTE_PTR  pCssmLengthAttr;

  CK_RV           PkcsStatus;

  CSSM_CONTEXT_ATTRIBUTE_PTR  pCssmSeedAttr;

  CSSM_BOOL         bSeedAllocated;
  CSSM_DATA         Seed;
  CSSM_DATA_PTR       pSeed;


  if ((pMsmSession = FindMsmSession(CssmCSPHandle)) == NULL)
    return SetErr(CSSM_CSP_INVALID_CSP_HANDLE);

  if (pCssmContext->ContextType != CSSM_ALGCLASS_RANDOMGEN)
    return SetErr(CSSM_CSP_INVALID_CONTEXT);

  if (pCssmContext->AlgorithmType != CSSM_ALGID_PKCS11Random)
    return SetErr(CSSM_CSP_ALGORITHM_UNSUPPORTED);

  pCssmLengthAttr = CSSM_GetContextAttribute(pCssmContext, CSSM_ATTRIBUTE_OUTPUT_SIZE);
  if (pCssmLengthAttr == NULL)
    return SetErr(CSSM_CSP_PARAM_NO_OUTPUT_SIZE);
  
  bSeedAllocated = CSSM_FALSE;
  pCssmSeedAttr = CSSM_GetContextAttribute(pCssmContext, CSSM_ATTRIBUTE_SEED);
  if (pCssmSeedAttr == NULL)
  {
    if ((Seed.Data = CssmMemFuncs.malloc_func(CssmCSPHandle, DEFAULTSEEDLEN)) == NULL)
    { 
      return SetErr(CSSM_CALLOC_FAILED);
    }

    Seed.Length = DEFAULTSEEDLEN;
    if (GetSeed(&Seed) == CSSM_FAIL)
      return CSSM_FAIL;

    bSeedAllocated = CSSM_TRUE;
  }
  else
  {
    if (pCssmSeedAttr->Attribute.Crypto != NULL)
    {
      if (pCssmSeedAttr->Attribute.Crypto->Callback == NULL)
      {
        if (pCssmSeedAttr->Attribute.Crypto->Param != NULL &&
          pCssmSeedAttr->Attribute.Crypto->Param->Data != NULL &&
          pCssmSeedAttr->Attribute.Crypto->Param->Length != 0)
        {
          Seed.Data   = pCssmSeedAttr->Attribute.Crypto->Param->Data;
          Seed.Length = pCssmSeedAttr->Attribute.Crypto->Param->Length;
        }
        else
        {
          return SetErr(CSSM_CSP_INVALID_DATA_POINTER);
        }
      }
      else
      {
        pSeed = pCssmSeedAttr->Attribute.Crypto->Callback(
                NULL, 
                pCssmSeedAttr->Attribute.Crypto->CallbackID);
        if (pSeed->Data == NULL || pSeed->Length == 0)
          return SetErr(CSSM_CSP_INVALID_DATA_POINTER);
        Seed.Data = pSeed->Data;
        Seed.Length = pSeed->Length;
      }
    }
    else
    {
      return SetErr(CSSM_CSP_INVALID_DATA_POINTER);
    }
  }

  if (bSeedAllocated == CSSM_TRUE)
    CssmMemFuncs.free_func(CssmCSPHandle, Seed.Data);
  

  if (pCssmRandomNumber->Data == NULL && pCssmRandomNumber->Length == 0)
  {
    pCssmRandomNumber->Length = pCssmLengthAttr->Attribute.Uint32;
    if ((pCssmRandomNumber->Data = CssmMemFuncs.calloc_func(CssmCSPHandle, 
                                1,
                                  pCssmRandomNumber->Length)) != NULL)
      MsmBufferAllocated = CSSM_TRUE;
    else
      return SetErr(CSSM_CALLOC_FAILED);
  }   

#ifdef PKCS11_V20
  if ((PkcsStatus = C_GenerateRandom(pMsmSession->PkcsSessionHandle,  
                     pCssmRandomNumber->Data, 
                     pCssmLengthAttr->Attribute.Uint32)) != CKR_OK)
#else
  if ((PkcsStatus = C_GenerateRandom(pMsmSession->PkcsSessionHandle,  
                     pCssmRandomNumber->Data, 
                     (CK_USHORT)pCssmLengthAttr->Attribute.Uint32)) != CKR_OK)
#endif
  {
    if (MsmBufferAllocated)
      CssmMemFuncs.free_func(CssmCSPHandle, pCssmRandomNumber->Data);
    return SetErr(PkcsStatus);
  }

  return CSSM_OK;
}
