/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include "exception.hpp"
#include "cssmerr.h"
#include "misc.hpp"

#include "ibmcylinkcsp.hpp"
#include "bytearraykeygen.hpp"
#include "deskeygen.hpp"
#include "tdeskeygen.hpp"
#include "dsakeygen.hpp"
#include "dhkeygen.hpp"
#include "toolkit.h"
#include "dhkey.hpp"
#include <iostream.h>

/**********************************************************
 *
 *	KeyGen class
 *
 **********************************************************/
KeyGen::KeyGen(CSSM_CC_HANDLE ctxHandle, uint32 algId, Random* randSource) 
:Context(ctxHandle, CSSM_ALGCLASS_KEYGEN, algId)
{
	switch (algId) {
	case CSSM_ALGID_DES :
		engine = new DESKeyGenEngine(randSource);
		break;
	case CSSM_ALGID_3DES:
	case CSSM_ALGID_3DES_3KEY:
	case CSSM_ALGID_3DES_2KEY:
	case CSSM_ALGID_3DES_1KEY:
		engine = new TDESKeyGenEngine(algId, randSource);
		break;
	case CSSM_ALGID_SAFER:
		engine = new ByteArrayKeyGenEngine(algId, randSource);
		break;
	case CSSM_ALGID_DSA:
		engine = new DSAKeyGenEngine(randSource);
		break;
	case CSSM_ALGID_DH:
		engine = new DHKeyGenEngine(randSource);
		break;
	default:
		throw InputException(CSSM_CSP_UNKNOWN_ALGORITHM);
		break;
	}
}

KeyGen::~KeyGen() {
	if (engine != NULL)
		delete engine;
}

void KeyGen::init(CssmData &seed, void *params) {
	//engine cannot be NULL, so I do not check
	engine->init(seed, params);
}

AlgorithmParams* KeyGen::generateParams(void *paramsIn) {
	//engine cannot be NULL, so I do not check
	return(engine->generateParams(paramsIn));
}

/*void KeyGen::generateParams(Key* key, void *paramsIn) {
	//engine cannot be NULL, so I do not check
	if (key == NULL)
		throw InputException(CSSM_CSP_INVALID_KEY_POINTER);

	engine->generateParams(key, paramsIn);
}*/

void KeyGen::generateKeyMat(Key *key, uint32 length) {
	//engine cannot be NULL, so I do not check
	engine->generateKeyMat(key, length);
}

void KeyGen::generateKeyMat(Key *key, AlgorithmParams* algParams) {
	//engine cannot be NULL, so I do not check
	engine->generateKeyMat(key, algParams);
}

void KeyGen::generateKeyMat(KeyMaterial *keyMat, uint32 length) {
	//engine cannot be NULL, so I do not check
	engine->generateKeyMat(keyMat, length);
}

void KeyGen::generateKeyMat(KeyMaterial *keyMat, AlgorithmParams* algParams) {
	//engine cannot be NULL, so I do not check
	engine->generateKeyMat(keyMat, algParams);
}

/* Not Used
void KeyGen::generateLikeKeyMat(Key *key) {
	//engine cannot be NULL, so I do not check
	engine->generateLikeKeyMat(key);
}

void KeyGen::generateLikeKeyMat(KeyMaterial *keyMat) {
	//engine cannot be NULL, so I do not check
	engine->generateLikeKeyMat(keyMat);
}
*/

/**********************************************************
 *
 *	KeyGenEngine class
 *
 **********************************************************/
KeyGenEngine::KeyGenEngine(uint32 algId, Random	*randSource) {
	this->algId = algId;
	if (randSource != NULL) {
		this->randSource = randSource;
	} 
	else {
		this->randSource = new Random(0, CSSM_ALGID_SHARandom);
	}
}

KeyGenEngine::~KeyGenEngine() {
	if (randSource != NULL) {
		delete randSource;
	}
}

void KeyGenEngine::init(CssmData &seed, void *params) {
	CssmData	tmpSeed = seed.clone();
	randSource->init(tmpSeed);
}


uint32 KeyGenEngine::getAlgId() {
	return (algId);
}

KeyMaterial* KeyGenEngine::getKeyMat(Key *key) {
	if (key == NULL)
		throw InputException(CSSM_CSP_INVALID_KEY_POINTER);

	return (key->keyMat);
}


KeyMaterial* KeyGenEngine::instantiateKeyMat(Key &key) {
	return(key.instantiateKeyMat());
}

AlgorithmParams* KeyGenEngine::generateParams(void *paramsIn) {
	throw InternalException(CSSM_CSP_NOT_IMPLEMENTED);
	return(NULL);
}

/*void KeyGenEngine::generateParams(Key* key, void *paramsIn) {
	throw InternalException(CSSM_CSP_NOT_IMPLEMENTED);
}*/

void KeyGenEngine::generateKeyMat(Key *key, uint32 length) {
	throw InternalException(CSSM_CSP_NOT_IMPLEMENTED);
}

void KeyGenEngine::generateKeyMat(Key *key, AlgorithmParams* algParams) {
	throw InternalException(CSSM_CSP_NOT_IMPLEMENTED);
}

void KeyGenEngine::generateKeyMat(KeyMaterial *keyMat, uint32 length) {
	throw InternalException(CSSM_CSP_NOT_IMPLEMENTED);
}

void KeyGenEngine::generateKeyMat(KeyMaterial *keyMat, AlgorithmParams* algParams) {
	throw InternalException(CSSM_CSP_NOT_IMPLEMENTED);
}

void KeyGenEngine::generateLikeKeyMat(Key *key) {
	throw InternalException(CSSM_CSP_NOT_IMPLEMENTED);
}

void KeyGenEngine::generateLikeKeyMat(KeyMaterial *keyMat) {
	throw InternalException(CSSM_CSP_NOT_IMPLEMENTED);
}
