/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*************************************************************************************
 *
 * COMPONENT_NAME: CSP - IBMCYLINKCSP (Software Service Provider)
 *
 * (C) COPYRIGHT International Business Machines Corp. 1997
 * All rights reserved
 * Licensed materials - Property of IBM
 *
 */

/*
 * FILE: ibmcylinkcsp_reginfo.hpp
 *
 * This file contains the information that will be stored in the registry upon 
 * addin installation.
 *
 * History:
 *
 *		Identifier		Date		Description
 *		----------		----------	-----------
 *		ANDY000			04/10/1998	Initial File Creation
 *
 *************************************************************************************/

#ifndef _IBMCYLINKCSP_REGINFO_HPP
#define _IBMCYLINKCSP_REGINFO_HPP

#include "cssmtype.h"

#define IBMCYLINKCSP_VENDOR "IBM Corporation"
#define IBMCYLINKCSP_DESCRIPTION "CDSA compliant CSP based on the Cylink cryptographic toolkit"
#define IBMCYLINKCSP_FLAGS (/*CSSM_MODULE_THREADSAFE |*/ CSSM_MODULE_EXPORTABLE)
#define IBMCYLINKCSP_SERVICE_MASK CSSM_SERVICE_CSP
#define IBMCYLINKCSP_NUMBER_OF_SERVICES 1
#define IBMCYLINKCSP_RESERVED NULL

#define IBMCYLINKCSP_SERVICE_TYPE CSSM_SERVICE_CSP
#define IBMCYLINKCSP_SERVICE_FLAGS CSSM_SERVICE_ISWRAPPEDPRODUCT
#define IBMCYLINKCSP_NUMBER_OF_SUBSERVICES 1
#define IBMCYLINKCSP_SERVICE_RESERVED NULL

#define IBMCYLINKCSP_SUBSERVICE_CSP_FLAGS 0
#define IBMCYLINKCSP_SUBSERVICE_CSPCUSTOM_FLAGS 0
#define IBMCYLINKCSP_SUBSERVICE_ACCESS_FLAGS 0
#define IBMCYLINKCSP_CSPTYPE CSSM_CSP_SOFTWARE
#define IBMCYLINKCSP_SUBSERVICE_RESERVED NULL

#define IBMCYLINKCSP_WRAPPED_PRODUCT_STANDARD_VERSION_MAJOR 0
#define IBMCYLINKCSP_WRAPPED_PRODUCT_STANDARD_VERSION_MINOR 0
#define IBMCYLINKCSP_WRAPPED_PRODUCT_STANDARD_DESCRIPTION "N/A"
#define IBMCYLINKCSP_WRAPPED_PRODUCT_PRODUCT_VERSION_MAJOR 1
#define IBMCYLINKCSP_WRAPPED_PRODUCT_PRODUCT_VERSION_MINOR 0
#define IBMCYLINKCSP_WRAPPED_PRODUCT_DESCRIPTION "Cylink Cryptographic Toolkit"
#define IBMCYLINKCSP_WRAPPED_PRODUCT_VENDOR "Cylink Corporation"
#define IBMCYLINKCSP_WRAPPED_PRODUCT_FLAGS 0

#endif //_IBMCYLINKCSP_REGINFO_HPP
