/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef _CIPHER_HPP
#define _CIPHER_HPP

#include "cssmtype.h"
#include "toolkit.h"
#include "context.hpp"
#include "key.hpp"

class DllExport CipherEngine {
public:
	CipherEngine(uint32 algId, uint32 mode);
	virtual ~CipherEngine();

	virtual void	encryptInit(Key *key, void *params) = 0;
	virtual void	encryptUpdate(CssmData &clearBuff, CssmData &cipherBuff, uint32 *bytesEncrypted) = 0;
	virtual void	encryptFinal(CssmData &remData) = 0;

	virtual void	decryptInit(Key *key, void *params) = 0;
	virtual void	decryptUpdate(CssmData &cipherBuff, CssmData &clearBuff, uint32 *bytesDecrypted) = 0;
	virtual void	decryptFinal(CssmData &remData) = 0;

	virtual uint32 getCipherTextLength(uint32 ClearTextLength) = 0;
	virtual uint32 getCipherRemLength(uint32 ClearTextLength) = 0;
	virtual uint32 getCipherMaxRemLength() = 0;
	virtual uint32 getClearTextLength(uint32 CipherTextLength) = 0;
	virtual uint32 getClearRemLength(uint32 CipherTextLength) = 0;
	virtual uint32 getClearMaxRemLength() = 0;

protected:
	uint32	algId;
	uint32	mode;
};

class DllExport Cipher : public Context {
public:
	Cipher(CSSM_CC_HANDLE ctxHandle, uint32 algId, uint32 mode);
	~Cipher();

	void encryptInit(Key *key, void *params);
	void encryptUpdate(CSSM_DATA_PTR clearBuff, uint32 clearBuffCount,
					   CSSM_DATA_PTR cipherBuff, uint32 cipherBuffCount,
					   uint32 *bytesEncrypted);
	void encryptUpdate(CssmData *clearBuff, uint32 clearBuffCount,
					   CssmData *cipherBuff, uint32 cipherBuffCount,
					   uint32 *bytesEncrypted);
	void encryptFinal(CSSM_DATA_PTR remData);
	void encryptFinal(CssmData &remData);
	void encrypt(Key *key, void *params,
				   CssmData *clearBuff, uint32 clearBuffCount,
				   CssmData *cipherBuff, uint32 cipherBuffCount,
				   uint32 *bytesEncrypted, CssmData &remData);
	void encrypt(Key *key, void *params,
				   CSSM_DATA_PTR clearBuff, uint32 clearBuffCount,
				   CSSM_DATA_PTR cipherBuff, uint32 cipherBuffCount,
				   uint32 *bytesEncrypted, CSSM_DATA_PTR remData);

	void decryptInit(Key *key, void *params);
	void decryptUpdate(CSSM_DATA_PTR cipherBuff, uint32 cipherBuffCount,
					   CSSM_DATA_PTR clearBuff, uint32 clearBuffCount,
					   uint32 *bytesDecrypted);
	void decryptUpdate(CssmData *cipherBuff, uint32 cipherBuffCount,
					   CssmData *clearBuff, uint32 clearBuffCount,
					   uint32 *bytesDecrypted);
	void decryptFinal(CSSM_DATA_PTR remData);
	void decryptFinal(CssmData &remData);
	void decrypt(Key *key, void *params, CSSM_DATA_PTR cipherBuff, uint32 cipherBuffCount,
					   CSSM_DATA_PTR clearBuff, uint32 clearBuffCount,
					   uint32 *bytesDecrypted, CSSM_DATA_PTR remData);
	void decrypt(Key *key, void *params, CssmData *cipherBuff, uint32 cipherBuffCount,
					   CssmData *clearBuff, uint32 clearrBuffCount,
					   uint32 *bytesDecrypted, CssmData &remData);

	uint32 getCipherTextLength(uint32 ClearTextLength);
	uint32 getCipherRemLength(uint32 ClearTextLength);
	uint32 getCipherMaxRemLength();
	uint32 getClearTextLength(uint32 CipherTextLength);
	uint32 getClearRemLength(uint32 CipherTextLength);
	uint32 getClearMaxRemLength();
	uint32 getMode();

private:
	uint32			mode;
	CipherEngine	*engine;
};

#endif //_CIPHER_HPP
