#ifndef JONAH_CL_I_H_
#define JONAH_CL_I_H_

#include "JonahCL.h"


extern CSSM_SPI_MEMORY_FUNCS clmUpcallTable;  //located in JonahCL.cpp


CSSM_DATA_PTR CSSMAPI CL_CertSign(CSSM_CL_HANDLE CLHandle,
                                  CSSM_CC_HANDLE CCHandle,
                                  const CSSM_DATA_PTR CertToBeSigned,
                                  const CSSM_DATA_PTR SignerCert,
                                  const CSSM_FIELD_PTR SignScope,
                                  uint32 ScopeSize);

CSSM_BOOL CSSMAPI CL_CertVerify(CSSM_CL_HANDLE CLHandle,
                                CSSM_CC_HANDLE CCHandle,
                                const CSSM_DATA_PTR CertToBeVerified,
                                const CSSM_DATA_PTR SignerCert,
                                const CSSM_FIELD_PTR VerifyScope,
                                uint32 ScopeSize);

CSSM_DATA_PTR CSSMAPI CL_CertCreateTemplate(CSSM_CL_HANDLE CLHandle,
                                            const CSSM_FIELD_PTR CertTemplate,
                                            uint32 NumberOfFields);

CSSM_DATA_PTR CSSMAPI CL_CertGetFirstFieldValue(CSSM_CL_HANDLE CLHandle,
                                                const CSSM_DATA_PTR Cert,
                                                const CSSM_OID_PTR CertField,
                                                CSSM_HANDLE_PTR ResultsHandle,
                                                uint32 * NumberOfMatchedFields);

CSSM_DATA_PTR CSSMAPI CL_CertGetNextFieldValue(CSSM_CL_HANDLE CLHandle,
                                               CSSM_HANDLE ResultsHandle);

CSSM_RETURN CSSMAPI CL_CertAbortQuery(CSSM_CL_HANDLE CLHandle,
                                      CSSM_HANDLE ResultsHandle);

CSSM_KEY_PTR CSSMAPI CL_CertGetKeyInfo(CSSM_CL_HANDLE CLHandle,
                                       const CSSM_DATA_PTR Cert);

CSSM_FIELD_PTR CSSMAPI CL_CertGetAllFields(CSSM_CL_HANDLE CLHandle,
                                           const CSSM_DATA_PTR Cert,
                                           uint32 * NumberOfFields);

CSSM_DATA_PTR CSSMAPI CL_CertImport(CSSM_CL_HANDLE CLHandle,
                                    CSSM_CERT_TYPE ForeignCertType,
                                    const CSSM_DATA_PTR ForeignCert);

CSSM_DATA_PTR CSSMAPI CL_CertExport(CSSM_CL_HANDLE CLHandle,
                                    CSSM_CERT_TYPE TargetCertType,
                                    const CSSM_DATA_PTR Cert);

CSSM_OID_PTR CSSMAPI CL_CertDescribeFormat(CSSM_CL_HANDLE CLHandle,
                                           uint32 * NumberOfFields);

CSSM_DATA_PTR CSSMAPI CL_CrlCreateTemplate(CSSM_CL_HANDLE CLHandle,
                                           const CSSM_FIELD_PTR Crltemplate,
                                           uint32 NumberOfFields);

CSSM_DATA_PTR CSSMAPI CL_CrlAddCert(CSSM_CL_HANDLE CLHandle,
                                    CSSM_CC_HANDLE CCHandle,
                                    const CSSM_DATA_PTR Cert,
                                    const CSSM_DATA_PTR RevokerCert,
                                    CSSM_REVOKE_REASON RevokeReason,
                                    const CSSM_DATA_PTR OldCrl);

CSSM_DATA_PTR CSSMAPI CL_CrlRemoveCert(CSSM_CL_HANDLE CLHandle,
                                       const CSSM_DATA_PTR Cert,
                                       const CSSM_DATA_PTR OldCrl);

CSSM_DATA_PTR CSSMAPI CL_CrlSign(CSSM_CL_HANDLE CLHandle,
                                 CSSM_CC_HANDLE CCHandle,
                                 const CSSM_DATA_PTR UnsignedCrl,
                                 const CSSM_DATA_PTR SignerCert,
                                 const CSSM_FIELD_PTR SignScope,
                                 uint32 ScopeSize);

CSSM_BOOL CSSMAPI CL_CrlVerify(CSSM_CL_HANDLE CLHandle,
                                   CSSM_CC_HANDLE CCHandle,
                                   const CSSM_DATA_PTR SubjectCrl,
                                   const CSSM_DATA_PTR SignerCert,
                                   const CSSM_FIELD_PTR VerifyScope,
                                   uint32 ScopeSize);

CSSM_BOOL CSSMAPI CL_IsCertInCrl(CSSM_CL_HANDLE CLHandle,
                                 const CSSM_DATA_PTR Cert,
                                 const CSSM_DATA_PTR Crl);

CSSM_DATA_PTR CSSMAPI CL_CrlGetFirstFieldValue(CSSM_CL_HANDLE CLHandle,
                                               const CSSM_DATA_PTR Crl,
                                               const CSSM_OID_PTR CrlField,
                                               CSSM_HANDLE_PTR ResultsHandle,
                                               uint32 * NumberOfMatchedFields);

CSSM_DATA_PTR CSSMAPI CL_CrlGetNextFieldValue(CSSM_CL_HANDLE CLHandle,
                                              CSSM_HANDLE ResultsHandle);

CSSM_RETURN CSSMAPI CL_CrlAbortQuery(CSSM_CL_HANDLE CLHandle,
                                     CSSM_HANDLE ResultsHandle);

CSSM_OID_PTR CSSMAPI CL_CrlDescribeFormat(CSSM_CL_HANDLE CLHandle,
                                          uint32 * NumberOfFields);

void * CSSMAPI CL_PassThrough(CSSM_CL_HANDLE CLHandle,
                              CSSM_CC_HANDLE CCHandle,
                              uint32 PassThroughId,
                              const void * InputParams);

CSSM_RETURN CSSMAPI CL_Initialize(CSSM_MODULE_HANDLE Handle,
                                  uint32 VerMajor,
                                  uint32 VerMinor);

CSSM_RETURN CSSMAPI CL_Terminate(CSSM_MODULE_HANDLE Handle);


BOOL WINAPI DllMain(Handle hInstance, DWORD dwReason, LPVOID lpReserved);

BOOL _init(void);

#endif