/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */
#include <x509.h>

unsigned char GeneralName::toupper_IA5(unsigned char c) const
{
   if ((c >= 0x61u) && (c <= 0x7au))      return c - 0x20;
   else if ((c >= 0xe0u) && (c <= 0xf6u)) return c - 0x20;
   else if ((c >= 0xf8u) && (c <= 0xfeu)) return c - 0x20;
   return c;
}

bool GeneralName::nocaseIa5Equal(const asn_ia5String &name1, const asn_ia5String &name2) const {
	buffer_t b1, b2;
	int status;
	unsigned int i; 

	if ((status = name1.get_value_IA5(b1)) != 0)
		return false;
	if ((status = name2.get_value_IA5(b2)) != 0)
		return false;

	if (b1.data_len != b2.data_len)
		return false;
	for (i = 0; i < b1.data_len; i++) {
		if (toupper_IA5(b1.data[i]) != toupper_IA5(b2.data[i]))
			return false; 
	}

	return true; 
}

bool GeneralName::rfc822Equal(const asn_ia5String &name1, const asn_ia5String &name2) const {
	return nocaseIa5Equal(name1, name2); 
}

bool GeneralName::dNSNameEqual(const asn_ia5String &name1, const asn_ia5String &name2) const {
	return nocaseIa5Equal(name1, name2); 
}

bool GeneralName::uRIEqual(const asn_ia5String &name1, const asn_ia5String &name2) const {
	buffer_t b1, b2;
	int status;
	unsigned int i; 

	if ((status = name1.get_value_IA5(b1)) != 0)
		return false;
	if ((status = name2.get_value_IA5(b2)) != 0)
		return false;

	if (b1.data_len != b2.data_len)
		return false;

	// The scheme is case insensitive
	for (i = 0; i < b1.data_len; i++) {
		if ((b1.data[i] == ':') || (b2.data[i] == ':'))
			if (!((b1.data[i] == ':') && (b2.data[i] == ':')))
				return false; 
			else 
				break; 
		if (toupper_IA5(b1.data[i]) != toupper_IA5(b2.data[i]))
			return false; 
	}

	// The rest of the string is case sensitive 
	if (strncmp(strchr((char *)b1.data, ':'), strchr((char *)b2.data, ':'), (b1.data_len - i)) == 0)
		return true;
	else
		return false; 
}

GeneralName::operator==(const GeneralName &gname) const {

	switch (selected()) {
	// 0 is rfc822Name; case insensitive
	case 0: 
		if (gname.selected() == 0)
			return (rfc822Equal(rfc822Name, gname.rfc822Name)); 
		else
			return false;
	// 1 is DNSName; case insensitive
	case 1:
		if (gname.selected() == 1)
			return (dNSNameEqual(dNSName, gname.dNSName));
		else
			return false;
	// 2 is directoryname; use that class's ==
	case 2:
		if (gname.selected() == 2)
			return (directoryname == gname.directoryname);
		else
			return false;	
	// 4 is URI; scheme is case insensitive, the rest is case sensitive 
	case 4:
		if (gname.selected() == 4)
			return (uRIEqual(uniformResourceIdentifier, gname.uniformResourceIdentifier));
		else
			return false;		
	// Others are unsupported  
	default: 
		return false; 
	}

}

GeneralName::operator==(const asn_x500name &dirname) const {
	GeneralName gname; 
	buffer_t buff; 

	// 2 is directory
	if (selected() == 2) {
		if (dirname.write(buff) != 0)
			return false; 
		if (gname.directoryname.read(buff) != 0)
			return false;
		return (*this == gname); 
	}
	return false; 
}

