.TH pemdb 5 "October 1994"  "7.0" "TIS/PEM"
.SH NAME
pemdb \- the TIS/PEM database file
.SH SYNOPSIS
.SH DESCRIPTION
The 
.B pemdb
file (
.B $HOME/.pemdb
by default)
contains user records separated by one or more blank
lines or comments, which are lines beginning with a pound sign (
.B #
The directive 
.B $include
.I filename,
which causes the named file to be included, also separates user records.
.PP
User records are processed sequentially and some processing
will terminate with the first user record that satisfies given
requirements while other processing will continue through all user
records.  User records contain tag/value field pairs.  Each tag/value
pair starts on a new line with a colon separating the tag and the
value.  Tag/value lines may be wrapped for readability by inserting a
new line and then one or more white space characters on the
continuation line.  Tags are case-insensitive and unknown tags are
ignored.
.PP
All tags in a user record may occur at most once, except for the
.B alias 
tag, which may occur multiple times.  User records are "anchored" by
public key, so public keys and certificates (well-dressed keys) must
be unique throughout all user records.  This is assumed, but not
enforced.  Programs will likely operate only on the first instance of
a tag/value pair in a user record if it is anything but the alias tag.
.PP
Some of the tag value pairs are redundant, but as long as the data is
consistent, fewer translations and decodings may be required for any
given processing.  To this end the software will always create
self-consistent user records.  For example, a user may have both
certificate and public-key fields, even though the certificate
contains the public key.  If redundant fields exist, consistency is
assumed, but not enforced.  Applications will likely operate on the
data easiest to handle for the processing at hand, so the results of
having inconsistent values may vary from application to application.
.PP
Following are the currently defined tags and the meanings and formats
of their values:
.PP
.B public-key:
The printably encoded, ASN.1 encoded public key.  Must match the
public key in certificate if certificate exists.  This tag/value pair
"anchors" the user record and must be present.  Records without this
pair may be ignored.
.PP
.B trusted: 
Alias of a user record placing trust in this public key, followed by a
comma and the PEM signature (same contents as MIC-Info field) by that
user of the rest of this user record excluding the
.B trusted
and
.B CRL
tag/value pairs.  Indicates a trusted user record. This field provides
the basis for all trust models in TIS/PEM.
.PP
.B certificate:
The printably encoded, ASN.1 encoded certificate.  Must contain same
information as in broken-out fields (public-key, subject-name,
issuer-name, serial-number).
.PP
.B crl:
The printably encoded, ASN.1 encoded CRL that has been signed
by the private key associated with this user record's public
key.
.PP
.B subject-name:
User friendly distinguished name of user as extracted from
certificate subject field or DN name form.  Must match
certificate subject distinguished name, if certificate exists.
.PP	
.B  issuer-name:
User friendly distinguished name of issuer extracted from
certificate or ISN name form.  Must match certificate issuer
name, if certificate exists.
.PP
.B serial-number:
Hexadecimal serial number extracted from certificate or ISN name form.
Must match certificate serial number, if certificate exists.
.PP
.B  id-dn-keyid:
.br
.B  id-en-keyid:
.br
.B  id-str-keyid:
.br
.B  id-pgp-keyid:
The keyid contents of any of the non-unique (DN, EN, STR, PGP)
name forms as received in an ID header.  
.PP
.B  id-dn:
.br
.B  id-en:
.br  
.B id-str:
.br
.B  id-pgp:
The non-keyid contents of any of the non-unique (DN, EN, STR,
PGP) name forms as received in an ID header.  
.PP
.B private-key-access: 

Method for accessing private key.  The only currently defined method
is
.B file
which mandates a private-key tag/value pair containing the rooted path
to the file containing the private key.
.PP
.B private-key: 
Additional information necessary to use private key based on
private-key-access method.  If the private key access method
is 
.B file,
the value for private-key is the fully qualified
name of the file containing the private key.
.PP
.B alias:
A token to identify a user record.  There can be more than one per
user record.  The same alias can be used in multiple user records to
identify a group of users, but there are times when only an alias that
identifies a single user record will be useful.  When a single user
record containing the alias is needed, the first one in the public
file is used.  Two special aliases are
.B me
and 
.B sig-user, 
which indicate user records that are the user's and the default user
record to use for signatures by default, respectively.
.SH FILES
$HOME/.pemrc,
$HOME/.pemdb
.SH SEE ALSO
pemrc(5), pem(1)
.SH BUGS
