/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "dname.h"
#include "util.h"

t612str(data, length, str)
unsigned char *data;
int length;
char *str[];
{
    int i, ret= NOTOK;
    char charstr[T61CHARLEN+1], *retstr= NULLCP;

    if (data == NULLUCP || str == NULLVP)
        return(ret);

    for (i = 0; i < length; i++) {
	if (isprint((int)data[i])) {
	    BZERO(charstr, sizeof(charstr));
	    charstr[0] = (char)data[i];
	}
	else 
	    sprintf(charstr, "%c%03o", PEM_ESCAPE_CHAR, data[i]);
	
        retstr = add2cp(retstr, charstr);
    }

    ret = OK;
    FREE(*str);
    *str = retstr;

    return(ret);
}
