/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <sys/stat.h>
#include <errno.h>
#include "general.h"

#include "util.h"

/*
 * for both dirchk and filchk
 * 
 * return -1 on error, 0 if no error, 1 if check failed
 *
 * if "mode" is less than 0 the permissions check is not done,
 * but it is an error to pass a negative number when creating
 */


#ifdef	TXENIX
#include <stdio.h>

static int mkdir(dir, mode)
char *dir;
int mode;
{
    int rc;
    char *cmdstr = NULLCP;

    cmdstr = add2cp(cmdstr, "emkdir ");
    cmdstr = add2cp(cmdstr, dir);
    rc = system(cmdstr);
    (void) free(cmdstr);

    return(rc);
}
#endif	/* TXENIX */


dirchk(dir, mode, make)
char *dir;
int mode, make;
{
    struct stat sbuf;
    int mask = -1;

    if (dir == NULLCP)
	return(-1);

    if (*dir == NULLC)
	return(-1);

 doagain:
    if (stat(dir, &sbuf)) {
	if (errno != ENOENT)
	    return(-1);

	if ( ! make)
	    return(1);

	if (mode < 0) {
	    mask = umask(0077);
	    mode = ~mask & 0777;
	}

	if (mkdir(dir, mode)) {
	    if (mask != -1)
		(void) umask(mask);
	    return(-1);
	}

	if (mask != -1)
	    (void) umask(mask);
	else {
	    if (chmod(dir, mode)) {
		/* should delete the directory just created */
		return(-1);
	    }
	}
	goto doagain;
    }

    if ((sbuf.st_mode & S_IFMT) != S_IFDIR)
	return(1);

    if (mode >= 0 && ((sbuf.st_mode & 0777) | mode) != mode)
	return(1);

    return(0);
}

filchk(file, mode, make)
char *file;
int mode, make;
{
    struct stat sbuf;
    int fd, mask = -1, mymake = 0;

    if (file == NULLCP)
	return(-1);

    if (*file == NULLC)
	return(-1);

 fagain:
    if (stat(file, &sbuf)) {
	if (errno != ENOENT)
	    return(-1);

	if ( ! make)
	    return(1);
	mymake = 1;

	if (mode < 0) {
	    mask = umask(0077);
	    mode = ~mask & 0777;
	}

	if ((fd = open(file, O_WRONLY | O_CREAT, mode)) < 0) {
	    if (mask != -1)
		(void) umask(mask);
	    return(-1);
	}

	if (mask != -1)
	    (void) umask(mask);
	else {
	    if (chmod(file, mode)) {
		(void) close(fd);
		(void) unlink(file);
		return(-1);
	    }
	}
	
	(void) close(fd);
	goto fagain;
    }

    if ((sbuf.st_mode & S_IFMT) != S_IFREG) {
	if (mymake)
	    (void) unlink(file); /* should never happen */
	return(1);
    }

    if (mode != NOPERMS && ((sbuf.st_mode & 0777) | mode) != mode) {
	if (mymake)
	    (void) unlink(file); /* should never happen */
	return(1);
    }

    return(0);
}
