/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <ctype.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "dname.h"
#include "new.h"
#include "util.h"


/* Create a public key pair or self-signed-certificate/key pair based
 *  on the information in the supplied template and return a new user
 *  record containing the new pair and other information from the
 *  template.  
 */

char **pem_key(template, iocbs)
char **template;
struct cbstruct *iocbs;
{
    struct bbuf  *pubkey = NULLBB;
    struct bbuf  *privkey = NULLBB;

    char        **user = NULLVP; 
  
    if (template == NULLVP || iocbs == NULL_IOCBS)
	goto cleanup;

    /* we must have private-key and private-key-access tags */

    if (tag_user(template, "private-key-access") == NULLVP
	|| tag_user (template, "private-key") == NULLVP) {
	(void) cp2cb(iocbs->out_errs,
		     "missing private-key-access or private-key\n");
	goto cleanup;
    }

    user = merge_user(NULLVP, template);

    /* create the key pair */

 {
    struct algent  *ae = NULL_ALGENT;
    char          **av = NULLVP;
    int             key_len;

    struct bbuf    *pass = NULLBB;
    struct bbuf    *bbuf = NULLBB;

    if ((av = tag_user(user_tailor, "key-alg")) == NULLVP) {
	(void) cp2cb(iocbs->out_errs, "missing key-alg\n");
	goto cleanup;
    }

    if ((ae = getalgstr(algorithms, *(av+1), IK|SIG)) == NULL_ALGENT) {
	(void) cp2cb(iocbs->out_errs, "unknown key-alg\n");
	goto cleanup;
    }

    if ((av = tag_user(user_tailor, "key-len")) == NULLVP) {
	(void) cp2cb(iocbs->out_errs, "missing key-len\n");
	goto cleanup;
    }

    key_len = atoi(*(av+1));
    if (key_len < ae->minlen || key_len > ae->maxlen) {
	(void) cp2cb(iocbs->out_errs, "invalid key-len\n");
	goto cleanup;
    }

    /* get private key password */

    pass = get_password(iocbs, 1);

    (void) cp2cb(iocbs->out_user, 
		 "Generating key pair.  This may take some time...\n");

    if (gen_key(ae->code, key_len, &pubkey, &privkey) != OK) {
	(void) cp2cb(iocbs->out_errs,
		     "unable to generate public/private key pair\n");
	goto cleanup;
    }

    (void) cp2cb(iocbs->out_user, "Done generating key pair.\n");

    /* add the public/private keys to the user record */

    if (bencode(pubkey, &bbuf) != OK) {
	if (iocbs != NULL_IOCBS && iocbs->out_errs != NULL_OUTCB)
	    (void) cp2cb(iocbs->out_errs,
			 "unable to encode public-key for user record\n");
	goto cleanup;
    }
    user = add2av(user, add2cp(NULLCP, "public-key"));
    user = add2av(user, (char *)bbuf -> data);

    if (sav_key(user, pass, privkey) != OK) {
	if (iocbs != NULL_IOCBS && iocbs->out_errs != NULL_OUTCB)
	    (void) cp2cb(iocbs->out_errs, "unable to save private key\n");
	goto cleanup;
    }
 }

    /* create the certificate if that's what we're doing */
 {
    char  **serial;
    char  **dn;
    char  **tmpuser = NULLVP;

    if ((serial = tag_user(user, "serial-number")) != NULLVP
	&& (dn = tag_user(user, "subject-name")) != NULLVP) {

	long         beginvalid, endvalid;
	struct bbuf *bb = NULLBB, *cert = NULLBB;

	/* fill in all the pieces */

	cert = alloc_bbuf();

	if ((bb = hex2bin(*(serial+1))) == NULLBB
	    || serial_cert(&cert, &bb, WRITE) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "unable to insert serial-number in certificate\n");
	    goto cleanup;
	}
	FREE_BBUF(bb);

	if (version_cert(&cert, &cert_version, WRITE) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "unable to insert version in certificate\n");
	    goto cleanup;
	}
	
	if ((bb = str2dn(*(dn+1))) == NULLBB
	    || issuer_cert(&cert, &bb, WRITE) != OK
	    || subject_cert(&cert, &bb, WRITE) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "unable to insert subject-name in certificate\n");
	    goto cleanup;
	}
	FREE_BBUF(bb);
    {
	char **av;
	long   validperiod = 0L;

	if ((av = tag_user(user_tailor, "cert-period")) != NULLVP) 
	    validperiod = str2valid(*(av+1));
	beginvalid = TIME();
	endvalid = beginvalid + validperiod;
	if (valid_cert(&cert, &beginvalid, &endvalid, WRITE) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "unable to insert validity period in certificate\n");
	    goto cleanup;
	}
    }
	if (key_cert(&cert, &pubkey, WRITE) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "unable to insert public-key in certificate\n");
	    goto cleanup;
	}

	/* self-sign the certificate */

	if (sign_cert(&cert, privkey) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "unable to self-sign the certificate\n");
	    goto cleanup;
	}

	/* printably encode the certificate */

	if (bencode(cert, &bb) != OK) {
	    (void) cp2cb(iocbs->out_errs,
			 "unable to encode certificate for user record\n");
	    goto cleanup;
	}

	/* explode the certificate and merge the results into user */

	if ((tmpuser = explode_cert((char *)bb -> data)) == NULLVP ||
	(user = merge_user(user, tmpuser)) == NULLVP) {
	    (void) cp2cb(iocbs->out_errs,
			 "unable to merge new certificate information\n");
	    goto cleanup;
	}

	FREE_AV(tmpuser);
	FREE_BBUF(bb);
	FREE_BBUF(cert);
    }
 }

    /* all done; create the new user record to return */

    user = merge_user(template, user);

    FREE_BBUF(privkey);
    FREE_BBUF(pubkey);

    return user;

 cleanup:

    FREE_AV(user);

    FREE_BBUF(privkey);
    FREE_BBUF(pubkey);

    return user;
}
