/* This is the Lex definition for MIME integrated PEM messages */

%{

#include "config.h"

#include "y.tab.h"

#define  INITIAL 0

int lexdebug= 0;
int yydebug= 0;

%}

%s HEADERS

vBLANKLINE	^\n
vVRSION		^"Version:"[ ]*
vDEKINFO	^"DEK-Info:"[ ]*
vKEYINFO	^"Key-Info:"[ ]*
vORIGID		^"Originator-ID:"[ ]*
vRECIPID	^"Recipient-ID:"[ ]*
vMICINFO	^"MIC-Info:"[ ]*
vUNKHEADER	^.+:
vDES		 "DES"[ ]*
vDES_CBC	 "DES-CBC"[ ]*
vRSA 		 "RSA"[ ]*
vRSA_MD2 	 "RSA-MD2"[ ]*
vRSA_MD5 	 "RSA-MD5"[ ]*
vHSKIP		 ","[ ]*
vID_EN		 "EN"[ ]*
vID_STR		 "STR"[ ]*
vID_DN		 "DN"[ ]*
vID_PGP2	 "PGP2"[ ]*
vID_PK		 "PK"[ ]*
vID_IS		 "IS"[ ]*

%%

<INITIAL>{vVRSION}		{ BEGIN HEADERS;
				  if (lexdebug) fprintf(yyout,"\nVERSION:");
				  return VRSION; }

<HEADERS>{vHSKIP}		;

<HEADERS>{vBLANKLINE}		{ BEGIN INITIAL; 
				  if (lexdebug) fprintf(yyout,"\nBLANKLINE\n");
				  return BLANKLINE; } 

<HEADERS>{vDEKINFO}		{ if (lexdebug) fprintf(yyout,"\n\nDEKINFO:");
				  return DEKINFO; }

<HEADERS>{vKEYINFO}		{ if (lexdebug) fprintf(yyout,"\n\nKEYINFO:");
				  return KEYINFO; }

<HEADERS>{vORIGID}		{ if (lexdebug) fprintf(yyout,"\n\nORIGID:");
				  return ORIGID; }

<HEADERS>{vRECIPID}		{ if (lexdebug) fprintf(yyout,"\n\nRECIPID:");
				  return RECIPID; }

<HEADERS>{vMICINFO}		{ if (lexdebug) fprintf(yyout,"\n\nMICINFO:");
				  return MICINFO; }

<HEADERS>{vDES}			{ if (lexdebug) fprintf(yyout,"\nDES:");
				  strcpy(yylval.str, yytext);
				  return DES; }

<HEADERS>{vDES_CBC}		{ if (lexdebug) fprintf(yyout,"\nDES_CBC:");
				  strcpy(yylval.str, yytext);
				  return DES_CBC; }

<HEADERS>{vRSA}			{ if (lexdebug) fprintf(yyout,"\nRSA:");
				  strcpy(yylval.str, yytext);
				  return RSA; }

<HEADERS>{vRSA_MD2}		{ if (lexdebug) fprintf(yyout,"\nRSA_MD2:");
				  strcpy(yylval.str, yytext);
				  return RSA_MD2; }

<HEADERS>{vRSA_MD5}		{ if (lexdebug) fprintf(yyout,"\nRSA_MD5:");
				  strcpy(yylval.str, yytext);
				  return RSA_MD5; }

<HEADERS>{vID_EN}		{ if (lexdebug) fprintf(yyout,"\nEN:");
				  strcpy(yylval.str, yytext);
				  return ID_EN; }

<HEADERS>{vID_STR}		{ if (lexdebug) fprintf(yyout,"\nSTR:");
				  strcpy(yylval.str, yytext);
				  return ID_STR; }

<HEADERS>{vID_DN}		{ if (lexdebug) fprintf(yyout,"\nDN:");
				  strcpy(yylval.str, yytext);
				  return ID_DN; }

<HEADERS>{vID_PGP2}		{ if (lexdebug) fprintf(yyout,"\nPGP2:");
				  strcpy(yylval.str, yytext);
				  return ID_PGP2; }

<HEADERS>{vID_PK}		{ if (lexdebug) fprintf(yyout,"\nPK:");
				  strcpy(yylval.str, yytext);
				  return ID_PK; }

<HEADERS>{vID_IS}		{ if (lexdebug) fprintf(yyout,"\nIS:");
				  strcpy(yylval.str, yytext);
				  return ID_IS; }

<HEADERS>{vUNKHEADER}		{
				  strncpy(yylval.str,yytext,strlen(yytext)-1);
				  if (lexdebug) 
				      fprintf(yyout,"\nUNKHEADER: %s",yytext);
				  return UNKHEADER; }

<HEADERS>[^:,\n]+		{
				  strcpy(yylval.str, yytext);
				  if (lexdebug) 
				    fprintf(yyout,"\nHSTR: %s",yytext);
				  return HSTR; }

\n				;

%%
