/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "dname.h"
#include "oid.h"
#include "util.h"
#include "x500.h"

static _parse_rdns(), _parse_avas();

struct bbuf *str2dn(str)
char *str;
{
    char *tmp;
    struct bbuf *rdns= NULLBB, *ret= NULLBB;
    		

    if (str == NULLCP)
        return(ret);

    if (_parse_rdns(tmp=add2cp(NULLCP, str), &rdns) != OK) 
        goto cleanup;

    if (rdns_dname(ret=alloc_bbuf(), &rdns, WRITE) != OK) 
        goto cleanup;


 cleanup:

    FREE(tmp);
    return(ret);
}

static _parse_rdns(str, rdns)
char *str;
struct bbuf **rdns;
{
    struct bbuf *avas= NULLBB, *tmp= NULLBB,
		*bbptr= NULLBB;
    char 	*ptr1, *ptr2, *tcp= NULLCP;
    int 	i, ret= NOTOK;

    FREE_BBUFS(*rdns);

    for (ptr1 = str; ptr1 != NULLCP && *ptr1 != NULLC; ptr1 = ptr2) {
	/* Skip PEM_FIELD_DELIM */
	ptr1 += sizeof(PEM_FIELD_DELIM);

	/* Find the end of this RDN */
	for (ptr2=INDEX(ptr1, PEM_FIELD_DELIM);
	     ptr2 != NULLCP; 
	     ptr2=INDEX(ptr2+sizeof(PEM_FIELD_DELIM), PEM_FIELD_DELIM)) {

            /* Skip Characterset Designator */
            for (tcp=ptr2+sizeof(PEM_FIELD_DELIM), i=0;
                 tcp!=NULLCP && label_charset[i].str!=NULLCP; i++) {
		if (!strncasecmp(tcp,label_charset[i].str,
			      strlen(label_charset[i].str)))
		    break;
            }
	    if (label_charset[i].str!=NULLCP) {
		ptr2 += sizeof(PEM_FIELD_DELIM);
		continue;
	    }

            /* Skip escaped PEM_FIELD_DELIM */
	    if (*(ptr2+sizeof(char))==PEM_FIELD_DELIM) {
                BCOPY(ptr2+sizeof(PEM_FIELD_DELIM), ptr2, 
		      strlen(ptr2+sizeof(PEM_FIELD_DELIM)));
                ptr2[strlen(ptr2)-1] = NULLC;
		ptr2 += sizeof(PEM_FIELD_DELIM);
		continue;
	    }

	    /* Terminate this RDN */
	    if (ptr2 != NULLCP)
	        *ptr2 = NULLC;

	    if (_parse_avas(tcp=add2cp(NULLCP, ptr1), &avas) != OK
		|| avas_rdn(tmp=alloc_bbuf(), &avas, WRITE) != OK)
		goto cleanup;

	    if (*rdns == NULLBB) 
		*rdns = bbptr = tmp;
	    else {
		bbptr->next = tmp;
		tmp->prev = bbptr;
		bbptr = tmp;
	    }
	    if (ptr2 != NULLCP) 
		*ptr2 = PEM_FIELD_DELIM;
	    FREE(tcp);
	    /* Next RDN */
	    break;
	}
    }

    ret = OK;

 cleanup:

    if (ret != OK) 
	FREE_BBUFS(*rdns);
    return(ret);
}

static _parse_avas(str, avas)
char *str;
struct bbuf **avas;
{
    struct bbuf *ava= NULLBB, *bbptr= NULLBB, *bb= NULLBB, *tmp= NULLBB;
    OID oid= NULLOID;
    char *ptr, *tcp;
    char *csptr= NULLCP;
    char *oidstr;
    int legal, i, ret = NOTOK;
    unsigned short attribute;

    FREE_BBUFS(*avas);
 
    /* Parse attributes and values and check for character
       set designators */
    for (ptr=tcp=str; tcp!=NULLCP; ptr=tcp+sizeof(PEM_SUBSUBFIELD_DELIM)) {
	if ((tcp=INDEX(ptr,PEM_SUBFIELD_DELIM)) != NULLCP)
	    *tcp = NULLC;
	else 
	    goto cleanup;

	/* Check for character set designator */
	if ((csptr=INDEX(ptr,PEM_FIELD_DELIM)) != NULLCP) {
	    *csptr = NULLC;
	    csptr += sizeof(PEM_FIELD_DELIM);
	}

	if (!(attribute = strilookup(label_attribute, ptr))
	    && !(oid=str2oid(ptr))) 
	    goto cleanup;

	oidstr = (attribute) ? vallookup(oidstr_attribute, attribute)
	    : add2cp(NULLCP, ptr);

	if ((oid = str2oid(oidstr)) == NULLOID) 
	    goto cleanup;
 
	ptr = tcp+sizeof(PEM_SUBFIELD_DELIM);
	if ((tcp == NULLCP) || (*ptr == NULLC)) 
            goto cleanup;

	/* Skip escaped PEM_SUBSUBFIELD_DELIM */
	for (tcp=INDEX(ptr,PEM_SUBSUBFIELD_DELIM); 
	     tcp!=NULLCP && 
	     *(tcp+sizeof(PEM_SUBSUBFIELD_DELIM))==PEM_SUBSUBFIELD_DELIM; 
	     tcp=INDEX(tcp+sizeof(PEM_SUBSUBFIELD_DELIM),
		       PEM_SUBSUBFIELD_DELIM)) {
	    BCOPY(tcp+sizeof(PEM_SUBSUBFIELD_DELIM), tcp, 
		  strlen(tcp+sizeof(PEM_SUBSUBFIELD_DELIM)));
	    tcp[strlen(tcp)-1] = NULLC;
	}
	if (tcp != NULLCP)
	    *tcp = NULLC;

        /* Encode value based on oid type */
        switch (strlookup(oidstr_syntax, oidstr)) {
	case CaseExactString:
	case PrintableString:
	case CaseIgnoreString:
	case CaseIgnoreList:
	case NumericString:
	case PhoneNumber:
	    /* Check for character set here */
            switch (strilookup(label_charset, csptr)) {
	    case DEFN_T61S:
	        if (encode_t61s(ptr, &bb) != OK)
		    goto cleanup;
		break;
	    default:
        	/* For now, we assume our two options are printable string or
		 * T61.  If the string contains a character which is not
		 * legal for DEFN_PRTS, we encode T61.
		 */
        	for (i=0,legal=1; legal && i<strlen(ptr); i++)
        	    legal = (INDEX(prts_chars,ptr[i]) != NULLCP);
        	if (!legal) {
        	    if (encode_t61s(ptr, &bb) != OK) 
                	goto cleanup;
        	}
        	else {
        	    if (encode_prts(ptr, &bb) != OK) 
                	goto cleanup;
        	}
	    }
	    break;

	case Boolean:
	case Integer:
	    if (encode_int(atoi(ptr), &bb) != OK)
		goto cleanup;
	    break;

	case UTCTime:
	    if (encode_utct(atol(ptr), &bb) != OK)
		goto cleanup;
	    break;

	case OctetString:
	    if (ptr != NULLCP && *ptr != NULLC) {
	        tmp = alloc_bbuf();
	        tmp->length = strlen(ptr);
	        tmp->data = alloc_uchar(tmp->length);
	        BCOPY((unsigned char *)ptr, tmp->data, tmp->length);
	    }
	    if (encode_octs(tmp, &bb) != OK)
		goto cleanup;
	    break;

	default:
	    if ((bb = hex2bin(ptr)) == NULLBB)
		goto cleanup;
        }

	if (encode_ava(oid, bb, &ava) != OK)
	    goto cleanup;

	if (*avas == NULLBB) 
	    *avas = bbptr = ava;
	else {
	    bbptr->next = ava;
	    ava->prev = bbptr;
	    bbptr = ava;
	}
	ava = NULLBB;
    }

    ret = OK;

 cleanup:

    FREE_BBUF(bb);
    FREE_BBUF(tmp);
    if (ret != OK) 
	FREE_BBUFS(*avas);

    return(ret);
}
