/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "dname.h"
#include "oid.h"
#include "x500.h"
#include "util.h"

static _read_rdns(), _write_rdns(); 

rdns_dname(dname, rdns, mode)
struct bbuf *dname;
struct bbuf **rdns;
int mode;
{
#ifdef	DEBUG
    char *cp;
#endif	/* DEBUG */

    if (dname == NULLBB) 
	return(NOTOK);

    if (rdns == (struct bbuf **)0) 
	return(NOTOK);

    switch (mode) {
    case READ:
	return(_read_rdns(dname, rdns));

    case WRITE:
	FREE_UCHAR(dname->data);
	dname->length = 0;
	if (*rdns == NULLBB) 
	    return(OK);
	else
	    return(_write_rdns(dname, *rdns));

    case APPEND:
	if (*rdns == NULLBB) 
	    return(OK);
	else
	    return(_write_rdns(dname, *rdns));

    default:

	return(NOTOK);
    }
}


static _read_rdns(dn, list)
struct bbuf *dn;
struct bbuf  **list;
{
    int ret = NOTOK, pos = 0;

    /* Parse out individual rdn's */
    if ((asn_extract(dn, list, &pos) & TAG_MASK) != CONS_SEQ ||
        asn_parse(dn, list) != OK) 
        goto cleanup;

    ret = OK;

 cleanup:

    return(ret);
}


static _write_rdns(bbuf, list)
struct bbuf *bbuf;
struct bbuf  *list;
{
    struct bbuf *ptr = NULLBB, *tagbb = NULLBB,
		*lenbb = NULLBB, *retbb = NULLBB,
		*tmp = NULLBB;
    int         pos = 0, ret = NOTOK;

    /* parse existing rdn's if they exist */
    (void) asn_extract(bbuf, &retbb, &pos);

    for (ptr = list; ptr != NULLBB; ptr = ptr->next) {
        retbb = bbufcat(tmp=retbb, ptr);
        FREE_BBUF(tmp);
    }

    if (encode_len(retbb->length, &lenbb) != OK)
        goto cleanup;
    if (encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &tagbb) != OK)
	goto cleanup;

    retbb = bbufcat(lenbb, tmp=retbb);
    FREE_BBUF(tmp);
    retbb = bbufcat(tagbb, tmp=retbb);
    FREE_BBUF(tmp);

    FREE_UCHAR(bbuf->data);
    bbuf->data = retbb->data;
    retbb->data = NULLUCP;
    bbuf->length = retbb->length;

    ret = OK;

 cleanup:
    FREE_BBUF(lenbb);
    FREE_BBUF(tagbb);
    FREE_BBUF(retbb);

    return(ret);
}
