/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "dname.h"
#include "oid.h"
#include "util.h"

int encode_ava(oid, val, eava)
OID		oid;
struct bbuf	*val;
struct bbuf	**eava;
{
    int ret = NOTOK;
    struct bbuf *retbb= NULLBB, *bb= NULLBB, *tmpbb= NULLBB;

    /* CHECK PARAMETERS */
    if (oid == NULLOID) 
	return(NOTOK);

    if (val == NULLBB) 
	return(NOTOK);

    if (eava == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*eava);
    
    /* ENCODE THE ATTRIBUTE TYPE */
    if (encode_oid(oid, &bb) != OK)
	goto cleanup;

    retbb = bbufcat(bb, val);

    /* ENCODE THE LENGTH */
    if (encode_len(retbb->length, &bb) != OK)
        goto cleanup;
    retbb = bbufcat(bb, tmpbb=retbb);
    FREE_BBUF(tmpbb);

    /* ENCODE THE TAG */
    if (encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb) != OK)
        goto cleanup;
    retbb = bbufcat(bb, tmpbb=retbb);
    FREE_BBUF(tmpbb);

    ret = OK;

 cleanup:

    FREE_BBUF(bb);
    *eava = retbb;
    if (ret != OK) 
        FREE_BBUF(*eava);

    return(ret);
}
