/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "dname.h"
#include "oid.h"
#include "util.h"
#include "x500.h"

decode_ava(ava, oid, val)
struct bbuf 	*ava;
OID 		*oid;
struct bbuf 	**val;
{
    struct bbuf *list= NULLBB;
    int  dummy, pos= 0, ret= NOTOK;

    if (ava == NULLBB) 
        return(ret);

    if (oid == (OID *)0) 
        return(ret);

    FREE_OID(*oid);
 
    if (val == (struct bbuf **)0) 
        goto cleanup;

    FREE_BBUF(*val);
 
    if ((asn_extract(ava, &list, &pos) & TAG_MASK) != CONS_SEQ ||
        asn_parse(ava, &list) != OK || list == NULLBB || 
	list->next == NULLBB) 
	goto cleanup;

    if (decode_oid(list, oid, &dummy) != OK) 
        goto cleanup;

    *val = list->next;
    list->next = NULLBB;

    ret = OK;

 cleanup:
    FREE_BBUF(list);

    return(ret);
}
