/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"
#include "x500.h"

/* Parse a sequence of ASN.1 encoded objects from a bbuf*/

asn_parse(bbuf, list)
struct bbuf *bbuf, 
	    **list;
{
    struct bbuf *sub_bbuf= NULLBB, *tmp= NULLBB, 
		*tagbb= NULLBB, *lenbb= NULLBB, *bb, *ptr;
    unsigned char tag;
    int ret= NOTOK, pos= 0;

    if (bbuf == NULLBB) 
        return(ret);

    if (list == (struct bbuf **)0) 
        goto cleanup;

    FREE_BBUFS(*list);

    /* Strip header (tag + length) */
    if ((ret=asn_extract(bbuf, &sub_bbuf, &pos)) == PARSE_ERROR)
        goto cleanup;

    if ((ret & FORM_MASK) == FORM_CONS) 
        /* Build the list of subelements */
        for (pos=0; (tag=asn_extract(sub_bbuf, &tmp, &pos)) != PARSE_ERROR; ) {
	    if (encode_tag(tag, &tagbb) != OK || 
	        encode_len(tmp->length, &lenbb) != OK)
                goto cleanup;
            tmp = bbufcat(lenbb, bb=tmp);
            FREE_BBUF(bb);
            tmp = bbufcat(tagbb, bb=tmp);
            FREE_BBUF(bb);

	    if (*list == NULLBB)
	        *list = ptr = tmp;
	    else {
	        ptr->next = tmp;
	        tmp->prev = ptr;
	        ptr = tmp;
	    }
	    tmp = NULLBB;
        }
    else
	*list = dup_bbuf(sub_bbuf);

    ret = OK;

 cleanup:
    FREE_BBUF(sub_bbuf);
    FREE_BBUF(tagbb);
    FREE_BBUF(lenbb);
    FREE_BBUF(tmp);
    if (ret != OK)
	FREE_BBUFS(*list);

    return(ret);
}
