/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "allocate.h"
#include "user_list.h"
#include "util.h"

struct user_list *alloc_ul()
{
    struct user_list *ul;

    allocate(&ul, struct user_list, sizeof(struct user_list));

    if (ul != NULLUL) {
	ul->user = NULLVP;
	ul->next = NULLUL;
    }

    return ul;
}


int free_ul(ul)
struct user_list *ul;
{
    if (ul != NULLUL) {
        FREE_AV(ul->user);
	free((char *) ul);
    }

    return OK;
}


int free_uls(uls)
struct user_list *uls;
{
    struct user_list *ul = NULLUL, *next = NULLUL;

    for (ul = uls; ul != NULLUL; ul = next) {
	next = ul->next;
	FREE_UL(ul);
    }
    
    return OK;
}
