/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"

decipher(user, ibbuf, obbuf)
char           **user;          /* user record containing public key */
struct bbuf	*ibbuf;		/* input buffer */
struct bbuf    **obbuf;		/* output buffer */
{
    struct bbuf	*key = NULLBB;
    int ret = NOTOK;

    if (obbuf == (struct bbuf **)0)
	return(EINVAL);
    FREE_BBUF(*obbuf);

    if (user == NULLVP)
	return(EINVAL);

    if (ibbuf == NULLBB)
	return(EINVAL);

    if ((ret = get_key(user, NULLBB, &key)) != OK)
	goto cleanup;

    if ((ret = set_key(key)) != OK)
        goto cleanup;

    if ((ret = decipher(ibbuf, obbuf)) != OK)
	goto cleanup;

    /* ret is set to OK */

 cleanup:

    if (ret != OK)
        FREE_BBUF(*obbuf);

    FREE_BBUF(key);

    return(ret);
}
