/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 *  cbgen_md5.c
 ****************************************************************************/

#include <stdio.h>
#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "key.h"
#include "util.h"

#include "./global.h"
#include "./md5.h"

int cbgen_md5(dummy, cb, md5)
struct key *dummy;		/* ignored */
struct bbuf * (*cb)();
struct bbuf **md5;
{
    MD5_CTX mdContext;
    struct bbuf *buf = NULLBB;
    unsigned char md[MD5BLKLEN];

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (cb == NULL || md5 == (struct bbuf **)0)
	return(NOTOK);

    FREE_BBUF(*md5);

    /* Compute digest using MD5 routines */
    MD5Init(&mdContext);
    while ((buf = cb()) != NULLBB && buf->length != 0) {
	MD5Update(&mdContext, buf->data, (unsigned int)buf->length);
    }
    MD5Final(md, &mdContext);

    /* Allocate bbuf for digest */
    *md5 = alloc_bbuf();
    (*md5)->data = alloc_uchar(MD5BLKLEN);

    /* Copy the digest from the digest buffer */
    BCOPY(md, (*md5)->data, MD5BLKLEN);
    (*md5)->length = MD5BLKLEN;

    return(OK);
}

/****************************************************************************/
