/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include <stdio.h>
#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "key.h"
#include "util.h"

#include "./global.h"
#include "./md2.h"

int fgen_md2(dummy, fp, md2)
struct key *dummy;		/* ignored */
FILE *fp;
struct bbuf **md2;
{
    MD2_CTX mdContext;
    unsigned char md[MD2BLKLEN];
    unsigned char buf[BUFSIZ];
    int len;

    /* DOUBLE_CHECK FUNCTION PARAMETERS */
    if (fp == (FILE *)0 || md2 == (struct bbuf **)0)
	return(NOTOK);

    FREE_BBUF(*md2);

    /* Compute digest using MD2 routines */
    MD2Init(&mdContext);
    while ((len = fread((char *)buf, 1, BUFSIZ, fp)) != 0) 
	MD2Update(&mdContext, buf, (unsigned int)len);
    
    MD2Final(md, &mdContext);

    /* Allocate bbuf for digest */
    *md2 = alloc_bbuf();
    (*md2)->data = alloc_uchar(MD2BLKLEN);

    /* Copy the digest from the digest buffer */
    BCOPY(md, (*md2)->data, MD2BLKLEN);
    (*md2)->length = MD2BLKLEN;

    return(OK);
}
