/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * bbuf2desdata.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

int bbuf2desdata(dekbb, dek)
struct bbuf *dekbb;
struct key **dek;
{
    int r, alg;

    if (dekbb == NULLBB || dek == (struct key **)0 || 
	(*dek)->algid == NULL_ALGID)
	return(NOTOK);

    alg = (*dek)->algid->alg;

    switch(alg) {
    case DES:
    case DES_CBC:
	(void) setparity(dekbb);
	if ((r = encode_deskeydata(dekbb, &((*dek)->data))) != OK)
	    return(r);
	break;

    case DES_ECB:
    case DES_EDE:
	break;

    default:
	return(NOTOK);
    }

    return(OK);
}

/*****************************************************************************/
