/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

encode_utct(dutct, eutct)
long dutct;
struct bbuf **eutct;
{
    struct tm *tm;
    UTC ut;
    char *utctstr;
    struct bbuf *bb = NULLBB;
    int r = OK;

    if (eutct == (struct bbuf **)0) {
	return(NOTOK);
    }
    if (*eutct != (struct bbuf *)0) {
	(void) free_bbuf(*eutct);
	*eutct = (struct bbuf *)0;
    }

    tm = gmtime(&dutct);
    ut = (UTC) calloc(1, sizeof(struct UTCtime));
    (void) tm2ut(tm, ut);
    utctstr = time2str(ut, 0);
    (void) free((char *)ut);

    bb = alloc_bbuf();
    bb->data = (unsigned char *)utctstr;
    bb->length = strlen(utctstr);

    if (encode_str(bb, (CLASS_UNIV|FORM_PRIM|DEFN_UTCT), eutct) != OK) {
	r = NOTOK;
	goto cleanup;
    }

 cleanup:

    if (bb != NULLBB) {
	bb->data = (unsigned char *)0;
	(void) free_bbuf(bb);
    }

    return(r);
}
