/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

encode_t61s(dt61s, et61s)
char *dt61s;
struct bbuf **et61s;
{
    struct bbuf *bb = NULLBB;
    int r = NOTOK, slen;

    if (et61s == (struct bbuf **)0) 
	goto cleanup;

    FREE_BBUF(*et61s);

    if (dt61s != NULLCP) {
	if ((bb = alloc_bbuf()) == NULLBB) 
	    goto cleanup;
	slen = bb->length;
	if (str2t61(dt61s, &slen, &(bb->data)) != OK) {
	    bb->length = (short)slen;
	    goto cleanup;
	}
	bb->length = (short)slen;
    }

    if (encode_str(bb, (CLASS_UNIV|FORM_PRIM|DEFN_T61S), et61s) != OK) 
	goto cleanup;

    r = OK;

 cleanup:

    FREE_BBUF(bb);

    return(r);
}
