/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

encode_bits(dbits, ebits)
struct bbuf *dbits;
struct bbuf **ebits;
{
    struct bbuf *bb;
    struct bbuf *lenbb = NULLBB;
    int r;
	
    if (ebits == (struct bbuf **)0) {
	return(NOTOK);
    }

    if (*ebits != (struct bbuf *)0) {
	(void) free_bbuf(*ebits);
	*ebits = (struct bbuf *)0;
    }

    /* ENCODE MISSING BIT STRING AS A NULL */
    if (dbits == NULLBB || !dbits->length) 
	return(encode_null(CLASS_UNIV|FORM_PRIM|PRIM_NULL, ebits));

    if ((bb = bits2prim(dbits)) == (struct bbuf *)0) {
	return(NOTOK);
    }

    if ((r = encode_len(bb->length, &lenbb)) != OK)
	return(r);

    *ebits = alloc_bbuf();

    (*ebits)->data = alloc_uchar(1+lenbb->length+bb->length);
    (*ebits)->length = 1 + lenbb->length + bb->length;

    (*ebits)->data[0] = (CLASS_UNIV | FORM_PRIM | PRIM_BITS);
    BCOPY(lenbb->data, &((*ebits)->data[1]), lenbb->length);
    BCOPY(bb->data, &(*ebits)->data[1+lenbb->length], bb->length);

    (void) free_bbuf(bb);
    (void) free_bbuf(lenbb);

    return(OK);
}
