/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#ifndef	_GENERAL_
#define _GENERAL_

#define NULLC	(char)0
#define NULLCP	(char *)0
#define NULLUC	(unsigned char)0
#define NULLUCP	(unsigned char *)0
#define NULLVP	(char **)0

#define FREE(x)		if ((x) != NULLCP) { \
			    (void) free(x); \
			    (x) = NULLCP; \
			} \
			else

#define FREE_UCHAR(x)	if ((x) != NULLUCP) { \
			    (void) free((char *)(x)); \
			    (x) = NULLUCP; \
			} \
			else

/* If you would like the code to decide whether or not to byte swap
   integral types, use the following definition of bswap(). */

#define BSWAP(var) {\
        unsigned char _t1[sizeof(var)];\
        unsigned char *_t2 = (unsigned char *)&(var);\
        unsigned char *_t;\
        int _i = 1;\
	_t = (unsigned char *)&_i;\
	if (*_t) {\
          for (_i = 0; _i < sizeof(var); _i++)\
            _t1[_i] = _t2[sizeof(var) - 1 - _i];\
          for (_i = 0; _i < sizeof(var); _i++)\
            _t2[_i] = _t1[_i];\
	}}

/* some useful manifest constants that are sometimes defined */

#ifndef	TRUE
#define TRUE			1
#define FALSE			0
#endif	/* not TRUE */

#ifndef	MAXHOSTNAMELEN
#define MAXHOSTNAMELEN		64
#endif	/* not MAXHOSTNAMELEN */

/* Define parameters for system lseek() call */

#ifndef	L_SET
#define L_SET 0
#define L_INCR 1
#define L_XTND 2
#endif	/* not L_SET */

/* all the return codes */

#include <errno.h>
#define OK	0
#define NOTOK	(-1)

/* maximum number of attempts allowed to enter password */

#define MAXPWTRIES	3

/* status BIT FLAG manifest constants for
 * certificate and crl validation
 */

#define BNOVAL  (unsigned short) 0x0001  /* validity period does not exist */
#define BBADVAL (unsigned short) 0x0002  /* "now" is outside validity period */
#define BNOISS  (unsigned short) 0x0004  /* issuer cert does not exist */
#define BNOSIG  (unsigned short) 0x0008  /* signature does not exist */
#define BBADSIG (unsigned short) 0x0010  /* signature is invalid */
#define BNOCRL  (unsigned short) 0x0020  /* issuer crl does not exist */
#define BBADCRL (unsigned short) 0x0040  /* certificate is on issuer crl */
#define BNOSDN  (unsigned short) 0x0080  /* no subject name in certificate */
#define BNOIDN  (unsigned short) 0x0100  /* no issuer name */
#define BSLFSGN (unsigned short) 0x0200  /* subject and issuer name equal */
#define BBADCHN (unsigned short) 0x0400  /* a cert in the chain is invalid */
#define BNOTOK  (unsigned short) 0x0800  /* certificate is NOT labelled OK */

#define BUNKNOWN (unsigned short) (BNOVAL|BBADVAL|BNOISS|BNOSIG|\
				   BBADSIG|BNOCRL|BBADCRL|BNOSDN|\
				   BNOIDN|BSLFSGN|BBADCHN|BNOTOK)

/* used by structure access routines */

#define READ	1
#define WRITE	2
#define APPEND  4

/* some oft used global variables; see init.h for details */

extern int       cpyright;
extern char     *myname;
extern char      errmsg[];
extern int       cert_version;
extern char    **user_tailor;

/* a few routines not declared elsewhere */

extern char	*getenv(), *getpass(), *getwd(), *mktemp(),
		*pem_copyright(), *pem_version();
extern long	atol();

/* THIS IS JUNK UNTIL WE REALLY GET RID OF LOGGING */

extern int lp;

#endif	/* _GENERAL_ */
