/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#ifndef _CRYPTOCB_
#define _CRYPTOCB_

#include "crypto.h"

/* Crypto callback table entry */
struct ccbent {
	int code;			/* internal id integer code */
	int (*gen_Xkey)();		/* generate key */
	int (*disp_Xkeyparms)();	/* display key parameters */
	int (*disp_Xkeydata)();		/* display key data */
	int (*addXparms2cp)();		/* convert key parms to string */
	int (*Xdata2bbuf)();		/* convert key data to bbuf */
	int (*str2Xparms)();		/* convert string to key parms */
	int (*bbuf2Xdata)();		/* convert bbuf to key data */
	int (*str2Xkey)();		/* convert string (password) to key */
	int (*encipher_X)();		/* block encipherment */
	int (*fencipher_X)();		/* file encipherment */
	int (*decipher_X)();		/* block decipherment */
	int (*fdecipher_X)();		/* file decipherment */
	int (*sign_X)();		/* block signature computation */
	int (*verify_X)();		/* block signature verification */
	int (*gen_Xmic)();		/* block generate MIC */
	int (*fgen_Xmic)();		/* file generate MIC */
};

#define NULL_CCBENT	(struct ccbent *)0

/* Crypto callback table */

extern int gen_deskey(), disp_deskeyparms(), disp_deskeydata(),
	   adddesparms2cp(), desdata2bbuf(), str2desparms(), 
	   bbuf2desdata(), str2deskey(), encipher_des(), 
	   fencipher_des(), decipher_des(), fdecipher_des();
extern int gen_rsakey(), disp_rsakeyparms(), disp_rsakeydata(),
	   encipher_rsa(), decipher_rsa(), sign_rsa(), verify_rsa();
extern int gen_md2(), fgen_md2();
extern int gen_md5(), fgen_md5();

#define NULL_FUNC	(int (*)())0

#ifndef lint
static struct ccbent callbacks[] = {

	{ MD2, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, gen_md2, fgen_md2 },

	{ MD5, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, gen_md5, fgen_md5 },

	{ DES_CBC, gen_deskey, disp_deskeyparms, disp_deskeydata,
	  adddesparms2cp, desdata2bbuf, str2desparms, bbuf2desdata,
	      str2deskey,
	  encipher_des, fencipher_des, decipher_des, fdecipher_des,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC },

	{ RSA, gen_rsakey, disp_rsakeyparms, disp_rsakeydata,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  encipher_rsa, NULL_FUNC, decipher_rsa, NULL_FUNC,
	  sign_rsa, verify_rsa, NULL_FUNC, NULL_FUNC },

	{ RSAENC, gen_rsakey, NULL_FUNC, disp_rsakeydata,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  encipher_rsa, NULL_FUNC, decipher_rsa, NULL_FUNC,
	  sign_rsa, verify_rsa, NULL_FUNC, NULL_FUNC },

	{ RSA_PUB|RSA_PUB3|RSA_PUBF4, gen_rsakey, disp_rsakeyparms,
	      disp_rsakeydata, 
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  encipher_rsa, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, verify_rsa, NULL_FUNC, NULL_FUNC },

	{ RSAENC|RSAENC_PUB3|RSAENC_PUBF4, gen_rsakey, NULL_FUNC,
	      disp_rsakeydata,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  encipher_rsa, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, verify_rsa, NULL_FUNC, NULL_FUNC },

	{ RSA_PRIV, gen_rsakey, disp_rsakeyparms, disp_rsakeydata,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, decipher_rsa, NULL_FUNC,
	  sign_rsa, NULL_FUNC, NULL_FUNC, NULL_FUNC },

	{ RSAENC_PRIV, gen_rsakey, NULL_FUNC, disp_rsakeydata,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, decipher_rsa, NULL_FUNC,
	  sign_rsa, NULL_FUNC, NULL_FUNC, NULL_FUNC },

	{ 0, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC,
	  NULL_FUNC, NULL_FUNC, NULL_FUNC, NULL_FUNC }

};
#else	/* lint */
extern struct ccbent callbacks[1];
#endif	/* lint */

/* Crypto callback table routines */
extern struct ccbent *getccbcode();

#endif	/* not _CRYPTOCB_ */
